/*
 * Decompiled with CFR 0.152.
 */
package net.fabricmc.loom.configuration;

import java.io.File;
import java.util.Optional;
import java.util.Set;
import net.fabricmc.loom.configuration.FileDependencyInfo;
import org.gradle.api.Project;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.artifacts.Dependency;
import org.gradle.api.artifacts.DependencySet;
import org.gradle.api.artifacts.FileCollectionDependency;
import org.gradle.api.artifacts.ResolvedDependency;
import org.gradle.api.artifacts.component.ComponentIdentifier;
import org.gradle.api.artifacts.component.ModuleComponentIdentifier;

public class DependencyInfo {
    final Project project;
    final Dependency dependency;
    final Configuration sourceConfiguration;
    private String resolvedVersion = null;

    public static DependencyInfo create(Project project, String configuration) {
        return DependencyInfo.create(project, project.getConfigurations().getByName(configuration));
    }

    public static DependencyInfo create(Project project, Configuration configuration) {
        DependencySet dependencies = configuration.getDependencies();
        if (dependencies.isEmpty()) {
            throw new IllegalArgumentException(String.format("Configuration '%s' has no dependencies", configuration.getName()));
        }
        if (dependencies.size() != 1) {
            throw new IllegalArgumentException(String.format("Configuration '%s' must only have 1 dependency", configuration.getName()));
        }
        return DependencyInfo.create(project, (Dependency)dependencies.iterator().next(), configuration);
    }

    public static DependencyInfo create(Project project, Dependency dependency, Configuration sourceConfiguration) {
        if (dependency instanceof FileCollectionDependency) {
            FileCollectionDependency fileCollectionDependency = (FileCollectionDependency)dependency;
            return new FileDependencyInfo(project, fileCollectionDependency, sourceConfiguration);
        }
        return new DependencyInfo(project, dependency, sourceConfiguration);
    }

    DependencyInfo(Project project, Dependency dependency, Configuration sourceConfiguration) {
        this.project = project;
        this.dependency = dependency;
        this.sourceConfiguration = sourceConfiguration;
    }

    public Dependency getDependency() {
        return this.dependency;
    }

    public String getResolvedVersion() {
        if (this.resolvedVersion != null) {
            return this.resolvedVersion;
        }
        for (ResolvedDependency rd : this.sourceConfiguration.getResolvedConfiguration().getFirstLevelModuleDependencies()) {
            if (!rd.getModuleGroup().equals(this.dependency.getGroup()) || !rd.getModuleName().equals(this.dependency.getName())) continue;
            this.resolvedVersion = rd.getModuleVersion();
            return this.resolvedVersion;
        }
        this.resolvedVersion = this.dependency.getVersion();
        return this.resolvedVersion;
    }

    public Configuration getSourceConfiguration() {
        return this.sourceConfiguration;
    }

    private boolean matches(ComponentIdentifier identifier) {
        if (identifier instanceof ModuleComponentIdentifier) {
            ModuleComponentIdentifier moduleComponentIdentifier = (ModuleComponentIdentifier)identifier;
            return moduleComponentIdentifier.getGroup().equals(this.dependency.getGroup()) && moduleComponentIdentifier.getModule().equals(this.dependency.getName()) && moduleComponentIdentifier.getVersion().equals(this.dependency.getVersion());
        }
        return false;
    }

    public Set<File> resolve() {
        return this.sourceConfiguration.getIncoming().artifactView(view -> view.componentFilter(this::matches)).getFiles().getFiles();
    }

    public Optional<File> resolveFile() {
        Set<File> files = this.resolve();
        if (files.isEmpty()) {
            return Optional.empty();
        }
        if (files.size() > 1) {
            StringBuilder builder = new StringBuilder(this.toString());
            builder.append(" resolves to more than one file:");
            for (File f : files) {
                builder.append("\n\t-").append(f.getAbsolutePath());
            }
            throw new RuntimeException(builder.toString());
        }
        return files.stream().findFirst();
    }

    public String toString() {
        return this.getDepString();
    }

    public String getDepString() {
        return this.dependency.getGroup() + ":" + this.dependency.getName() + ":" + this.dependency.getVersion();
    }

    public String getResolvedDepString() {
        return this.dependency.getGroup() + ":" + this.dependency.getName() + ":" + this.getResolvedVersion();
    }
}

