/*
 * Decompiled with CFR 0.152.
 */
package net.fabricmc.loom.util.fmj;

import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.fabricmc.loom.LoomGradleExtension;
import net.fabricmc.loom.util.fmj.FabricModJson;
import net.fabricmc.loom.util.fmj.FabricModJsonFactory;
import net.fabricmc.loom.util.gradle.SourceSetHelper;
import org.gradle.api.Project;
import org.gradle.api.provider.Provider;
import org.gradle.api.tasks.SourceSet;

public class FabricModJsonHelpers {
    public static List<FabricModJson> getModsInProject(Project project) {
        FabricModJson fabricModJson;
        LoomGradleExtension extension = LoomGradleExtension.get(project);
        Provider overrideFile = extension.getFabricModJsonPath().getAsFile();
        if (overrideFile.isPresent()) {
            return List.of(FabricModJsonFactory.createFromFile((File)overrideFile.get()));
        }
        ArrayList<SourceSet> sourceSets = new ArrayList<SourceSet>();
        sourceSets.add(SourceSetHelper.getMainSourceSet(project));
        if (extension.areEnvironmentSourceSetsSplit()) {
            sourceSets.add(SourceSetHelper.getSourceSetByName("client", project));
        }
        if ((fabricModJson = FabricModJsonFactory.createFromSourceSetsNullable(project, (SourceSet[])sourceSets.toArray(SourceSet[]::new))) != null) {
            return List.of(fabricModJson);
        }
        return Collections.emptyList();
    }
}

