/*
 * Decompiled with CFR 0.152.
 */
package net.fabricmc.loom.configuration.processors;

import com.google.gson.JsonElement;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.UncheckedIOException;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.inject.Inject;
import net.fabricmc.loom.api.mappings.layered.MappingsNamespace;
import net.fabricmc.loom.api.processor.MinecraftJarProcessor;
import net.fabricmc.loom.api.processor.ProcessorContext;
import net.fabricmc.loom.api.processor.SpecContext;
import net.fabricmc.loom.util.Checksum;
import net.fabricmc.loom.util.fmj.FabricModJson;
import net.fabricmc.mappingio.MappedElementKind;
import net.fabricmc.mappingio.MappingReader;
import net.fabricmc.mappingio.MappingVisitor;
import net.fabricmc.mappingio.adapter.ForwardingMappingVisitor;
import net.fabricmc.mappingio.adapter.MappingNsRenamer;
import net.fabricmc.mappingio.tree.MappingTree;
import net.fabricmc.mappingio.tree.MemoryMappingTree;
import org.jspecify.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class ModJavadocProcessor
implements MinecraftJarProcessor<Spec> {
    private static final Logger LOGGER = LoggerFactory.getLogger(ModJavadocProcessor.class);
    private final String name;

    @Inject
    public ModJavadocProcessor(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    @Override
    public @Nullable Spec buildSpec(SpecContext context) {
        ArrayList<ModJavadoc> javadocs = new ArrayList<ModJavadoc>();
        for (FabricModJson fabricModJson : context.allMods()) {
            ModJavadoc javadoc = ModJavadoc.create(fabricModJson, context.productionNamespace());
            if (javadoc == null) continue;
            javadocs.add(javadoc);
        }
        if (javadocs.isEmpty()) {
            return null;
        }
        javadocs.sort(Comparator.comparing(ModJavadoc::modId));
        return new Spec(Collections.unmodifiableList(javadocs));
    }

    @Override
    public void processJar(Path jar, Spec spec, ProcessorContext context) {
    }

    @Override
    public @Nullable MinecraftJarProcessor.MappingsProcessor<Spec> processMappings() {
        return (mappings, spec, context) -> {
            for (ModJavadoc javadoc : spec.javadocs()) {
                javadoc.apply(mappings);
            }
            return true;
        };
    }

    public record ModJavadoc(String modId, MemoryMappingTree mappingTree, String mappingsHash) {
        public static @Nullable ModJavadoc create(FabricModJson fabricModJson, MappingsNamespace productionNamespace) {
            String mappingsHash;
            String modId = fabricModJson.getId();
            JsonElement customElement = fabricModJson.getCustom("loom:provided_javadoc");
            if (customElement == null) {
                return null;
            }
            String javaDocPath = customElement.getAsString();
            MemoryMappingTree mappings = new MemoryMappingTree();
            try {
                byte[] data = fabricModJson.getSource().read(javaDocPath);
                mappingsHash = Checksum.of(data).sha1().hex();
                try (InputStreamReader reader = new InputStreamReader(new ByteArrayInputStream(data));){
                    Map<String, String> fallbackNamespaceReplacements = Map.of("source", productionNamespace.toString(), "target", MappingsNamespace.NAMED.toString());
                    MappingNsRenamer renamer = new MappingNsRenamer((MappingVisitor)mappings, fallbackNamespaceReplacements);
                    DstNameCheckingVisitor checker = new DstNameCheckingVisitor(modId, (MappingVisitor)renamer);
                    MappingReader.read((Reader)reader, (MappingVisitor)checker);
                }
            }
            catch (IOException e) {
                throw new UncheckedIOException("Failed to read javadoc from mod: " + modId, e);
            }
            if (!mappings.getSrcNamespace().equals(productionNamespace.toString())) {
                throw new IllegalStateException("Javadoc provided by mod (%s) must have an %s source namespace".formatted(modId, productionNamespace.toString()));
            }
            return new ModJavadoc(modId, mappings, mappingsHash);
        }

        public void apply(MemoryMappingTree target) {
            int targetNamespaceId = target.getNamespaceId(this.mappingTree.getSrcNamespace());
            if (targetNamespaceId == -2) {
                throw new IllegalStateException("Mapping tree must have namespace %s".formatted(this.mappingTree.getSrcNamespace()));
            }
            for (MappingTree.ClassMapping sourceClass : this.mappingTree.getClasses()) {
                MappingTree.ClassMapping targetClass = target.getClass(sourceClass.getSrcName(), targetNamespaceId);
                if (targetClass == null) {
                    LOGGER.warn("Could not find provided javadoc target class {} from mod {}", (Object)sourceClass.getSrcName(), (Object)this.modId);
                    continue;
                }
                this.applyComment(sourceClass, targetClass);
                for (MappingTree.FieldMapping sourceField : sourceClass.getFields()) {
                    MappingTree.FieldMapping targetField = targetClass.getField(sourceField.getSrcName(), sourceField.getSrcDesc(), targetNamespaceId);
                    if (targetField == null) {
                        LOGGER.warn("Could not find provided javadoc target field {}{} from mod {}", new Object[]{sourceField.getSrcName(), sourceField.getSrcDesc(), this.modId});
                        continue;
                    }
                    this.applyComment(sourceField, targetField);
                }
                for (MappingTree.MethodMapping sourceMethod : sourceClass.getMethods()) {
                    MappingTree.MethodMapping targetMethod = targetClass.getMethod(sourceMethod.getSrcName(), sourceMethod.getSrcDesc(), targetNamespaceId);
                    if (targetMethod == null) {
                        LOGGER.warn("Could not find provided javadoc target method {}{} from mod {}", new Object[]{sourceMethod.getSrcName(), sourceMethod.getSrcDesc(), this.modId});
                        continue;
                    }
                    this.applyComment(sourceMethod, targetMethod);
                }
            }
        }

        private <T extends MappingTree.ElementMapping> void applyComment(T source, T target) {
            String sourceComment = source.getComment();
            if (sourceComment == null) {
                LOGGER.warn("Mod {} provided javadoc has mapping for {}, without comment", (Object)this.modId, source);
                return;
            }
            Object targetComment = target.getComment();
            targetComment = targetComment == null ? "" : (String)targetComment + "\n";
            targetComment = (String)targetComment + sourceComment;
            target.setComment((String)targetComment);
        }

        @Override
        public int hashCode() {
            return Objects.hash(this.modId, this.mappingsHash);
        }

        @Override
        public String toString() {
            return "ModJavadoc{modId='%s', mappingsHash='%s'}".formatted(this.modId, this.mappingsHash);
        }
    }

    public record Spec(List<ModJavadoc> javadocs) implements MinecraftJarProcessor.Spec
    {
    }

    private static final class DstNameCheckingVisitor
    extends ForwardingMappingVisitor {
        private final String modId;

        DstNameCheckingVisitor(String modId, MappingVisitor next) {
            super(next);
            this.modId = modId;
        }

        public void visitDstName(MappedElementKind targetKind, int namespace, String name) {
            throw new IllegalStateException("Javadoc provided by mod (%s) must not contain any dst names".formatted(this.modId));
        }
    }
}

