/*
 * Decompiled with CFR 0.152.
 */
package net.fabricmc.loom.util;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.nio.file.FileSystemException;
import java.nio.file.FileSystems;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.UserDefinedFileAttributeView;
import java.util.Optional;

public final class AttributeHelper {
    private AttributeHelper() {
    }

    public static Optional<String> readAttribute(Path path, String key) throws IOException {
        Path attributesFile = AttributeHelper.getFallbackPath(path, key);
        if (AttributeHelper.exists(attributesFile)) {
            return Optional.of(Files.readString(attributesFile, StandardCharsets.UTF_8));
        }
        try {
            UserDefinedFileAttributeView attributeView = Files.getFileAttributeView(path, UserDefinedFileAttributeView.class, new LinkOption[0]);
            if (!attributeView.list().contains(key)) {
                return Optional.empty();
            }
            ByteBuffer buffer = ByteBuffer.allocate(attributeView.size(key));
            attributeView.read(key, buffer);
            buffer.flip();
            String value = StandardCharsets.UTF_8.decode(buffer).toString();
            return Optional.of(value);
        }
        catch (FileSystemException ignored) {
            return Optional.empty();
        }
    }

    public static void writeAttribute(Path path, String key, String value) throws IOException {
        Path attributesFile = AttributeHelper.getFallbackPath(path, key);
        try {
            UserDefinedFileAttributeView attributeView = Files.getFileAttributeView(path, UserDefinedFileAttributeView.class, new LinkOption[0]);
            byte[] bytes = value.getBytes(StandardCharsets.UTF_8);
            ByteBuffer buffer = ByteBuffer.wrap(bytes);
            int written = attributeView.write(key, buffer);
            assert (written == bytes.length);
            if (AttributeHelper.exists(attributesFile)) {
                Files.delete(attributesFile);
            }
        }
        catch (FileSystemException ignored) {
            Files.writeString(attributesFile, (CharSequence)value, StandardCharsets.UTF_8, new OpenOption[0]);
        }
    }

    private static Path getFallbackPath(Path path, String key) {
        return path.resolveSibling(String.valueOf(path.getFileName()) + "." + key + ".att");
    }

    private static boolean exists(Path path) {
        return path.getFileSystem() == FileSystems.getDefault() ? path.toFile().exists() : Files.exists(path, new LinkOption[0]);
    }
}

