/*
 * Decompiled with CFR 0.152.
 */
package net.fabricmc.loom.util.download;

import java.net.URISyntaxException;
import javax.inject.Inject;
import net.fabricmc.loom.LoomGradleExtension;
import net.fabricmc.loom.util.download.Download;
import net.fabricmc.loom.util.download.DownloadBuilder;
import org.gradle.api.Project;
import org.gradle.api.provider.Property;
import org.gradle.api.tasks.Input;

public abstract class DownloadFactory {
    @Input
    protected abstract Property<Boolean> getIsOffline();

    @Input
    protected abstract Property<Boolean> getIsManualRefreshDependencies();

    @Inject
    public abstract Project getProject();

    @Inject
    public DownloadFactory() {
        this.getIsOffline().set((Object)this.getProject().getGradle().getStartParameter().isOffline());
        this.getIsManualRefreshDependencies().set((Object)LoomGradleExtension.get(this.getProject()).refreshDeps());
    }

    public DownloadBuilder download(String url) {
        DownloadBuilder builder;
        try {
            builder = Download.create(url);
        }
        catch (URISyntaxException e) {
            throw new RuntimeException("Failed to create downloader for: " + String.valueOf(e));
        }
        if (((Boolean)this.getIsOffline().get()).booleanValue()) {
            builder.offline();
        }
        if (((Boolean)this.getIsManualRefreshDependencies().get()).booleanValue()) {
            builder.forceDownload();
        }
        return builder;
    }
}

