/*
 * Decompiled with CFR 0.152.
 */
package net.fabricmc.loom.util;

import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executor;
import java.util.concurrent.Executors;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import net.fabricmc.loom.util.CompletableFutureCollector;

public class AsyncCache<T> {
    private static final Executor EXECUTOR = Executors.newVirtualThreadPerTaskExecutor();
    private final Map<Object, CompletableFuture<T>> cache = new ConcurrentHashMap<Object, CompletableFuture<T>>();

    public CompletableFuture<T> get(Object cacheKey, Supplier<T> supplier) {
        return this.cache.computeIfAbsent(cacheKey, $ -> CompletableFuture.supplyAsync(supplier, EXECUTOR));
    }

    public T getBlocking(Object cacheKey, Supplier<T> supplier) {
        return AsyncCache.join(this.get(cacheKey, supplier));
    }

    public static <T> List<T> joinList(Collection<CompletableFuture<List<T>>> futures) {
        return AsyncCache.join(futures.stream().collect(CompletableFutureCollector.allOf())).stream().flatMap(Collection::stream).toList();
    }

    public static <K, V> Map<K, V> joinMap(Map<K, CompletableFuture<V>> futures) {
        return futures.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, entry -> AsyncCache.join((CompletableFuture)entry.getValue())));
    }

    public static <T> T join(CompletableFuture<T> future) {
        try {
            return future.join();
        }
        catch (CompletionException e) {
            AsyncCache.sneakyThrow(e.getCause() != null ? e.getCause() : e);
            throw new IllegalStateException();
        }
    }

    private static <E extends Throwable> void sneakyThrow(Throwable e) throws E {
        throw e;
    }
}

