/*
 * Decompiled with CFR 0.152.
 */
package net.fabricmc.loom.util.gradle.daemon;

import java.nio.file.Path;
import java.util.List;
import java.util.UUID;
import javax.inject.Inject;
import org.gradle.api.Project;
import org.gradle.api.provider.Property;
import org.gradle.api.tasks.Input;
import org.gradle.cache.FileLockManager;
import org.gradle.internal.file.Chmod;
import org.gradle.internal.remote.internal.Connection;
import org.gradle.internal.remote.internal.RemoteConnection;
import org.gradle.internal.remote.internal.inet.TcpOutgoingConnector;
import org.gradle.internal.serialize.Serializer;
import org.gradle.internal.serialize.Serializers;
import org.gradle.launcher.daemon.client.DaemonClientConnection;
import org.gradle.launcher.daemon.client.StopDispatcher;
import org.gradle.launcher.daemon.context.DaemonConnectDetails;
import org.gradle.launcher.daemon.protocol.Command;
import org.gradle.launcher.daemon.protocol.DaemonMessageSerializer;
import org.gradle.launcher.daemon.protocol.StopWhenIdle;
import org.gradle.launcher.daemon.registry.DaemonInfo;
import org.gradle.launcher.daemon.registry.PersistentDaemonRegistry;
import org.gradle.util.GradleVersion;
import org.jetbrains.annotations.VisibleForTesting;
import org.jspecify.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class DaemonUtils {
    private static final Logger LOGGER = LoggerFactory.getLogger(DaemonUtils.class);

    private DaemonUtils() {
    }

    public static void tryStopGradleDaemon(Context context) {
        try {
            DaemonUtils.stopWhenIdle(context);
        }
        catch (Throwable t) {
            LOGGER.error("Failed to request the Gradle demon to stop", t);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @VisibleForTesting
    public static boolean stopWhenIdle(Context context) {
        DaemonInfo daemonInfo = DaemonUtils.findCurrentDaemon(context);
        if (daemonInfo == null) {
            return false;
        }
        RemoteConnection connection = null;
        try {
            connection = new TcpOutgoingConnector().connect(daemonInfo.getAddress()).create(Serializers.stateful((Serializer)DaemonMessageSerializer.create(null)));
            DaemonClientConnection daemonClientConnection = new DaemonClientConnection(connection, (DaemonConnectDetails)daemonInfo, null);
            new StopDispatcher().dispatch((Connection)daemonClientConnection, (Command)new StopWhenIdle(UUID.randomUUID(), daemonInfo.getToken()));
        }
        finally {
            if (connection != null) {
                connection.stop();
            }
        }
        LOGGER.warn("Requested Gradle daemon to stop on exit.");
        return true;
    }

    private static @Nullable DaemonInfo findCurrentDaemon(Context context) {
        Path registryBin = Path.of((String)context.getRegistryBin().get(), new String[0]);
        LOGGER.info("Looking for daemon in: {}", (Object)registryBin);
        PersistentDaemonRegistry registry = new PersistentDaemonRegistry(registryBin.toFile(), context.getFileLockManager(), context.getChmod());
        long pid = ProcessHandle.current().pid();
        List runningDaemons = registry.getAll();
        LOGGER.info("Found {} running Gradle daemons in registry: {}", (Object)runningDaemons.size(), (Object)registryBin);
        for (DaemonInfo daemonInfo : runningDaemons) {
            if (daemonInfo.getPid() != pid) continue;
            return daemonInfo;
        }
        LOGGER.warn("Could not find current process in daemon registry: {}", (Object)registryBin);
        return null;
    }

    public static abstract class Context {
        @Input
        protected abstract Property<String> getRegistryBin();

        @Inject
        protected abstract FileLockManager getFileLockManager();

        @Inject
        protected abstract Chmod getChmod();

        @Inject
        public Context(Project project) {
            this.getRegistryBin().set((Object)Context.getRegistryBinPathName(project));
        }

        public static Context fromProject(Project project) {
            return (Context)project.getObjects().newInstance(Context.class, new Object[]{project});
        }

        private static String getRegistryBinPathName(Project project) {
            return project.getGradle().getGradleUserHomeDir().toPath().resolve("daemon").resolve(GradleVersion.current().getVersion()).resolve("registry.bin").toAbsolutePath().toString();
        }
    }
}

