/*
 * Decompiled with CFR 0.152.
 */
package net.fabricmc.loom.configuration.mods;

import java.io.IOException;
import java.nio.file.Path;
import java.util.List;
import net.fabricmc.classtweaker.api.ClassTweakerReader;
import net.fabricmc.classtweaker.api.ClassTweakerWriter;
import net.fabricmc.classtweaker.api.visitor.ClassTweakerVisitor;
import net.fabricmc.classtweaker.visitors.ClassTweakerRemapperVisitor;
import net.fabricmc.loom.util.fmj.FabricModJson;
import net.fabricmc.loom.util.fmj.FabricModJsonFactory;
import org.objectweb.asm.commons.Remapper;

public class AccessWidenerUtils {
    public static byte[] remapAccessWidener(byte[] input, Remapper remapper, String fromNamespace, String toNamespace) {
        int version = ClassTweakerReader.readVersion((byte[])input);
        ClassTweakerWriter writer = ClassTweakerWriter.create((int)version);
        ClassTweakerRemapperVisitor awRemapper = new ClassTweakerRemapperVisitor((ClassTweakerVisitor)writer, remapper, fromNamespace, toNamespace);
        ClassTweakerReader reader = ClassTweakerReader.create((ClassTweakerVisitor)awRemapper);
        reader.read(input, null);
        return writer.getOutput();
    }

    public static AccessWidenerData readAccessWidenerData(Path inputJar) throws IOException {
        if (!FabricModJsonFactory.isModJar(inputJar)) {
            return null;
        }
        FabricModJson fabricModJson = FabricModJsonFactory.createFromZip(inputJar);
        List<String> classTweakers = List.copyOf(fabricModJson.getClassTweakers().keySet());
        if (classTweakers.isEmpty()) {
            return null;
        }
        if (classTweakers.size() != 1) {
            throw new UnsupportedOperationException("TODO: support multiple class tweakers");
        }
        String accessWidenerPath = classTweakers.get(0);
        byte[] accessWidener = fabricModJson.getSource().read(accessWidenerPath);
        ClassTweakerReader.Header header = ClassTweakerReader.readHeader((byte[])accessWidener);
        return new AccessWidenerData(accessWidenerPath, header, accessWidener);
    }

    public record AccessWidenerData(String path, ClassTweakerReader.Header header, byte[] content) {
    }
}

