/*
 * Decompiled with CFR 0.152.
 */
package net.fabricmc.loom.api.decompilers;

import java.io.Serializable;
import java.util.Map;
import net.fabricmc.loom.util.Check;
import org.gradle.api.Named;
import org.gradle.api.file.ConfigurableFileCollection;
import org.gradle.api.provider.MapProperty;
import org.gradle.api.provider.Property;

public abstract class DecompilerOptions
implements Named {
    public abstract Property<String> getDecompilerClassName();

    public abstract ConfigurableFileCollection getClasspath();

    public abstract MapProperty<String, String> getOptions();

    public abstract Property<Long> getMemory();

    public abstract Property<Integer> getMaxThreads();

    public DecompilerOptions() {
        this.getDecompilerClassName().finalizeValueOnRead();
        this.getClasspath().finalizeValueOnRead();
        this.getOptions().finalizeValueOnRead();
        this.getMemory().convention((Object)4096L).finalizeValueOnRead();
        this.getMaxThreads().convention((Object)Runtime.getRuntime().availableProcessors()).finalizeValueOnRead();
    }

    public String getFormattedName() {
        return this.getName().substring(0, 1).toUpperCase() + this.getName().substring(1);
    }

    public Dto toDto() {
        Check.require(this.getDecompilerClassName().isPresent(), "No decompiler classname specified for decompiler: " + this.getName());
        return new Dto((String)this.getDecompilerClassName().get(), (Map)this.getOptions().get(), (Integer)this.getMaxThreads().get());
    }

    public record Dto(String className, Map<String, String> options, int maxThreads) implements Serializable
    {
    }
}

