/*
 * Decompiled with CFR 0.152.
 */
package net.fabricmc.loom.configuration.accesswidener;

import java.io.IOException;
import java.io.UncheckedIOException;
import java.lang.invoke.CallSite;
import java.nio.file.Path;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import net.fabricmc.classtweaker.api.ClassTweaker;
import net.fabricmc.loom.util.Pair;
import net.fabricmc.loom.util.ZipUtils;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.ClassWriter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class AccessWidenerTransformer {
    private static final Logger LOGGER = LoggerFactory.getLogger(AccessWidenerTransformer.class);
    private final ClassTweaker accessWidener;

    AccessWidenerTransformer(ClassTweaker accessWidener) {
        this.accessWidener = accessWidener;
    }

    void apply(Path jarFile) {
        try {
            Set targets = this.accessWidener.getTargets();
            int transformed = ZipUtils.transformAsync(jarFile, this.getTransformers(targets));
            LOGGER.debug("Applied access wideners to {} classes in {}", (Object)transformed, (Object)jarFile);
            if (targets.size() != transformed) {
                LOGGER.debug("Access widener target count ({}) does not match transformed class count ({}).", (Object)targets.size(), (Object)transformed);
            }
        }
        catch (IOException e) {
            throw new UncheckedIOException("Failed to apply access wideners to %s".formatted(jarFile), e);
        }
    }

    private List<Pair<String, ZipUtils.UnsafeUnaryOperator<byte[]>>> getTransformers(Set<String> classes) {
        return classes.stream().map(string -> new Pair<CallSite, ZipUtils.UnsafeUnaryOperator<byte[]>>((CallSite)((Object)(string + ".class")), this.getTransformer((String)string))).collect(Collectors.toList());
    }

    private ZipUtils.UnsafeUnaryOperator<byte[]> getTransformer(String className) {
        return input -> {
            ClassReader reader = new ClassReader(input);
            if (!reader.getClassName().equals(className)) {
                throw new IllegalStateException("Class name mismatch: expected %s but transforming %s".formatted(className, reader.getClassName()));
            }
            ClassWriter writer = new ClassWriter(0);
            ClassVisitor classVisitor = this.accessWidener.createClassVisitor(589824, (ClassVisitor)writer, null);
            LOGGER.debug("Applying access widener to {}", (Object)className);
            reader.accept(classVisitor, 0);
            return writer.toByteArray();
        };
    }
}

