/*
 * Decompiled with CFR 0.152.
 */
package net.fabricmc.loom.util;

import java.io.IOException;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executors;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.fabricmc.loom.util.FileSystemUtil;

public record JarPackageIndex(Map<String, List<String>> packages) {
    public static JarPackageIndex create(List<Path> jars) {
        Map<String, List<String>> packages = jars.stream().map(jar -> CompletableFuture.supplyAsync(() -> {
            try {
                List<String> classes = JarPackageIndex.getClasses(jar);
                return JarPackageIndex.groupClassesByPackage(classes);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }, Executors.newVirtualThreadPerTaskExecutor())).map(CompletableFuture::join).flatMap(map -> map.entrySet().stream()).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue, (existing, newValues) -> {
            existing.addAll(newValues);
            return existing;
        }));
        return new JarPackageIndex(packages);
    }

    private static List<String> getClasses(Path jar) throws IOException {
        try (FileSystemUtil.Delegate fs = FileSystemUtil.getJarFileSystem(jar, false);){
            List<String> list;
            block12: {
                Stream<Path> walk = Files.walk(fs.getRoot(), new FileVisitOption[0]);
                try {
                    list = walk.filter(x$0 -> Files.isRegularFile(x$0, new LinkOption[0])).map(Path::toString).filter(className -> className.endsWith(".class")).map(className -> className.startsWith("/") ? className.substring(1) : className).toList();
                    if (walk == null) break block12;
                }
                catch (Throwable throwable) {
                    if (walk != null) {
                        try {
                            walk.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                walk.close();
            }
            return list;
        }
    }

    private static Map<String, List<String>> groupClassesByPackage(List<String> classes) {
        return classes.stream().filter(className -> className.endsWith(".class")).collect(Collectors.groupingBy(JarPackageIndex::extractPackageName, Collectors.mapping(JarPackageIndex::extractClassName, Collectors.toList())));
    }

    private static String extractPackageName(String className) {
        int lastSlashIndex = className.lastIndexOf(47);
        return lastSlashIndex == -1 ? "" : className.substring(0, lastSlashIndex).replace("/", ".");
    }

    private static String extractClassName(String className) {
        int lastSlashIndex = className.lastIndexOf(47);
        String simpleName = lastSlashIndex == -1 ? className : className.substring(lastSlashIndex + 1);
        return simpleName.endsWith(".class") ? simpleName.substring(0, simpleName.length() - 6) : simpleName;
    }
}

