/*
 * Decompiled with CFR 0.152.
 */
package net.fabricmc.loom.task.service;

import daomephsta.unpick.constantmappers.datadriven.parser.v3.UnpickV3Reader;
import daomephsta.unpick.constantmappers.datadriven.parser.v3.UnpickV3Remapper;
import daomephsta.unpick.constantmappers.datadriven.parser.v3.UnpickV3Writer;
import daomephsta.unpick.constantmappers.datadriven.tree.UnpickV3Visitor;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import java.lang.reflect.Field;
import java.nio.file.Path;
import java.util.Collections;
import java.util.List;
import net.fabricmc.loom.api.mappings.layered.MappingsNamespace;
import net.fabricmc.loom.configuration.providers.mappings.unpick.UnpickMetadata;
import net.fabricmc.loom.task.service.TinyRemapperService;
import net.fabricmc.loom.task.service.TinyRemapperServiceInterface;
import net.fabricmc.loom.util.JarPackageIndex;
import net.fabricmc.loom.util.service.Service;
import net.fabricmc.loom.util.service.ServiceFactory;
import net.fabricmc.loom.util.service.ServiceType;
import net.fabricmc.tinyremapper.TinyRemapper;
import net.fabricmc.tinyremapper.api.TrClass;
import net.fabricmc.tinyremapper.api.TrField;
import org.gradle.api.Action;
import org.gradle.api.Project;
import org.gradle.api.provider.Property;
import org.gradle.api.provider.Provider;
import org.gradle.api.tasks.Nested;
import org.objectweb.asm.Type;
import org.objectweb.asm.commons.Remapper;

public class UnpickRemapperService
extends Service<Options> {
    public static final ServiceType<Options, UnpickRemapperService> TYPE = new ServiceType<Options, UnpickRemapperService>(Options.class, UnpickRemapperService.class);

    public static Provider<Options> createOptions(Project project, UnpickMetadata.V2 metadata) {
        return TYPE.create(project, (Action<Options>)((Action)options -> options.getTinyRemapper().set(TinyRemapperService.createSimple(project, (Provider<String>)project.provider(metadata::namespace), (Provider<String>)project.provider(MappingsNamespace.NAMED::toString), TinyRemapperService.ClasspathLibraries.INCLUDE))));
    }

    public UnpickRemapperService(Options options, ServiceFactory serviceFactory) {
        super(options, serviceFactory);
    }

    public String remap(File input) throws IOException {
        TinyRemapperServiceInterface tinyRemapperService = (TinyRemapperServiceInterface)this.getServiceFactory().get(((Options)this.getOptions()).getTinyRemapper());
        TinyRemapper tinyRemapper = tinyRemapperService.getTinyRemapperForRemapping();
        List<Path> classpath = ((TinyRemapperService.Options)((Options)this.getOptions()).getTinyRemapper().get()).getClasspath().getFiles().stream().map(File::toPath).toList();
        JarPackageIndex packageIndex = JarPackageIndex.create(classpath);
        return this.doRemap(input, tinyRemapper, packageIndex);
    }

    private String doRemap(File input, TinyRemapper remapper, JarPackageIndex packageIndex) throws IOException {
        try (BufferedReader fileReader = new BufferedReader(new FileReader(input));){
            String string;
            try (UnpickV3Reader reader = new UnpickV3Reader((Reader)fileReader);){
                UnpickV3Writer writer = new UnpickV3Writer();
                reader.accept((UnpickV3Visitor)new UnpickRemapper((UnpickV3Visitor)writer, remapper, packageIndex));
                string = writer.getOutput().replace(System.lineSeparator(), "\n");
            }
            return string;
        }
    }

    public static interface Options
    extends Service.Options {
        @Nested
        public Property<TinyRemapperService.Options> getTinyRemapper();
    }

    private static final class UnpickRemapper
    extends UnpickV3Remapper {
        private final TinyRemapper tinyRemapper;
        private final Remapper remapper;
        private final JarPackageIndex jarPackageIndex;

        private UnpickRemapper(UnpickV3Visitor downstream, TinyRemapper tinyRemapper, JarPackageIndex jarPackageIndex) {
            super(downstream);
            this.tinyRemapper = tinyRemapper;
            this.remapper = tinyRemapper.getEnvironment().getRemapper();
            this.jarPackageIndex = jarPackageIndex;
        }

        protected String mapClassName(String className) {
            return this.remapper.map(className.replace('.', '/')).replace('/', '.');
        }

        protected String mapFieldName(String className, String fieldName, String fieldDesc) {
            return this.remapper.mapFieldName(className.replace('.', '/'), fieldName, fieldDesc);
        }

        protected String mapMethodName(String className, String methodName, String methodDesc) {
            return this.remapper.mapMethodName(className.replace('.', '/'), methodName, methodDesc);
        }

        protected List<String> getClassesInPackage(String pkg) {
            return this.jarPackageIndex.packages().getOrDefault(pkg, Collections.emptyList()).stream().map(className -> pkg + "." + className).toList();
        }

        protected String getFieldDesc(String className, String fieldName) {
            String fieldDesc;
            TrClass trClass = this.tinyRemapper.getEnvironment().getClass(className.replace('.', '/'));
            if (trClass != null) {
                for (TrField trField : trClass.getFields()) {
                    if (!trField.getName().equals(fieldName)) continue;
                    return trField.getDesc();
                }
            }
            if ((fieldDesc = UnpickRemapper.getFieldDescFromReflection(className, fieldName)) == null) {
                throw new IllegalStateException("Could not find field " + fieldName + " in class " + className);
            }
            return fieldDesc;
        }

        private static String getFieldDescFromReflection(String className, String fieldName) {
            try {
                Class<?> clazz = Class.forName(className, false, null);
                Field field = clazz.getDeclaredField(fieldName);
                return Type.getDescriptor(field.getType());
            }
            catch (ClassNotFoundException | NoSuchFieldException e) {
                return null;
            }
        }
    }
}

