/*
 * Decompiled with CFR 0.152.
 */
package net.fabricmc.loom.configuration.decompile;

import net.fabricmc.loom.api.decompilers.DecompilerOptions;
import net.fabricmc.loom.configuration.decompile.DecompileConfiguration;
import net.fabricmc.loom.configuration.providers.minecraft.MinecraftJar;
import net.fabricmc.loom.configuration.providers.minecraft.mapped.MappedMinecraftProvider;
import net.fabricmc.loom.task.GenerateSourcesTask;
import net.fabricmc.loom.util.Strings;
import org.gradle.api.Action;
import org.gradle.api.Project;
import org.gradle.api.Task;
import org.gradle.api.tasks.TaskProvider;

public final class SplitDecompileConfiguration
extends DecompileConfiguration<MappedMinecraftProvider.Split> {
    public SplitDecompileConfiguration(Project project, MappedMinecraftProvider.Split minecraftProvider) {
        super(project, minecraftProvider);
    }

    @Override
    public String getTaskName(MinecraftJar.Type type) {
        return "gen%sSources".formatted(Strings.capitalize(type.toString()));
    }

    @Override
    public void afterEvaluation() {
        MinecraftJar commonJar = ((MappedMinecraftProvider.Split)this.minecraftProvider).getCommonJar();
        MinecraftJar clientOnlyJar = ((MappedMinecraftProvider.Split)this.minecraftProvider).getClientOnlyJar();
        TaskProvider<Task> commonDecompileTask = this.createDecompileTasks("Common", (Action<GenerateSourcesTask>)((Action)task -> {
            task.getInputJarName().set((Object)commonJar.getName());
            task.getSourcesOutputJar().fileValue(GenerateSourcesTask.getJarFileWithSuffix("-sources.jar", commonJar.getPath()));
        }));
        TaskProvider<Task> clientOnlyDecompileTask = this.createDecompileTasks("ClientOnly", (Action<GenerateSourcesTask>)((Action)task -> {
            task.getInputJarName().set((Object)clientOnlyJar.getName());
            task.getSourcesOutputJar().fileValue(GenerateSourcesTask.getJarFileWithSuffix("-sources.jar", clientOnlyJar.getPath()));
            task.mustRunAfter(new Object[]{commonDecompileTask});
        }));
        for (DecompilerOptions options : this.extension.getDecompilerOptions()) {
            String decompilerName = options.getFormattedName();
            TaskProvider commonTask = this.project.getTasks().named("gen%sSourcesWith%s".formatted("Common", decompilerName));
            TaskProvider clientOnlyTask = this.project.getTasks().named("gen%sSourcesWith%s".formatted("ClientOnly", decompilerName));
            clientOnlyTask.configure(task -> task.mustRunAfter(new Object[]{commonTask}));
            this.project.getTasks().register("genSourcesWith" + decompilerName, task -> {
                task.setDescription("Decompile minecraft using %s.".formatted(decompilerName));
                task.setGroup("fabric");
                task.dependsOn(new Object[]{commonTask});
                task.dependsOn(new Object[]{clientOnlyTask});
            });
        }
        this.project.getTasks().register("genSources", task -> {
            task.setDescription("Decompile minecraft using the default decompiler.");
            task.setGroup("fabric");
            task.dependsOn(new Object[]{commonDecompileTask});
            task.dependsOn(new Object[]{clientOnlyDecompileTask});
        });
    }

    private TaskProvider<Task> createDecompileTasks(String name, Action<GenerateSourcesTask> configureAction) {
        this.extension.getDecompilerOptions().forEach(options -> {
            String decompilerName = options.getFormattedName();
            String taskName = "gen%sSourcesWith%s".formatted(name, decompilerName);
            this.project.getTasks().register(taskName, GenerateSourcesTask.class, new Object[]{options}).configure(task -> {
                configureAction.execute((Object)task);
                task.dependsOn(new Object[]{this.project.getTasks().named("validateAccessWidener")});
                task.setDescription("Decompile minecraft using %s.".formatted(decompilerName));
                task.setGroup("fabric");
            });
        });
        return this.project.getTasks().register("gen%sSources".formatted(name), task -> {
            task.setDescription("Decompile minecraft (%s) using the default decompiler.".formatted(name));
            task.setGroup("fabric");
            task.dependsOn(new Object[]{this.project.getTasks().named("gen%sSourcesWith%s".formatted(name, "Vineflower"))});
        });
    }
}

