/*
 * Decompiled with CFR 0.152.
 */
package net.fabricmc.loom.util.kotlin;

import java.io.File;
import java.io.UncheckedIOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Set;
import java.util.stream.Collectors;
import net.fabricmc.loom.util.kotlin.KotlinClasspath;
import net.fabricmc.loom.util.kotlin.KotlinPluginUtils;
import net.fabricmc.loom.util.service.Service;
import net.fabricmc.loom.util.service.ServiceFactory;
import net.fabricmc.loom.util.service.ServiceType;
import org.gradle.api.Action;
import org.gradle.api.Project;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.artifacts.Dependency;
import org.gradle.api.file.ConfigurableFileCollection;
import org.gradle.api.provider.Property;
import org.gradle.api.provider.Provider;
import org.gradle.api.tasks.Classpath;
import org.gradle.api.tasks.Input;

public final class KotlinClasspathService
extends Service<Options>
implements KotlinClasspath {
    public static ServiceType<Options, KotlinClasspathService> TYPE = new ServiceType<Options, KotlinClasspathService>(Options.class, KotlinClasspathService.class);

    public static Provider<Options> createOptions(Project project) {
        if (!KotlinPluginUtils.hasKotlinPlugin(project)) {
            return project.getObjects().property(Options.class);
        }
        return KotlinClasspathService.createOptions(project, KotlinPluginUtils.getKotlinPluginVersion(project));
    }

    private static Provider<Options> createOptions(Project project, String kotlinVersion) {
        Configuration detachedConfiguration = project.getConfigurations().detachedConfiguration(new Dependency[]{project.getDependencies().create((Object)("org.jetbrains.kotlin:kotlin-stdlib:" + kotlinVersion)), project.getDependencies().create((Object)("org.jetbrains.kotlin:kotlin-metadata-jvm:" + kotlinVersion))});
        return TYPE.create(project, (Action<Options>)((Action)options -> {
            options.getClasspath().from(new Object[]{detachedConfiguration});
            options.getKotlinVersion().set((Object)kotlinVersion);
        }));
    }

    public KotlinClasspathService(Options options, ServiceFactory serviceFactory) {
        super(options, serviceFactory);
    }

    @Override
    public String version() {
        return (String)((Options)this.getOptions()).getKotlinVersion().get();
    }

    @Override
    public Set<URL> classpath() {
        return ((Options)this.getOptions()).getClasspath().getFiles().stream().map(KotlinClasspathService::fileToUrl).collect(Collectors.toSet());
    }

    private static URL fileToUrl(File file) {
        try {
            return file.toURI().toURL();
        }
        catch (MalformedURLException e) {
            throw new UncheckedIOException(e);
        }
    }

    public static interface Options
    extends Service.Options {
        @Classpath
        public ConfigurableFileCollection getClasspath();

        @Input
        public Property<String> getKotlinVersion();
    }
}

