/*
 * Decompiled with CFR 0.152.
 */
package net.fabricmc.loom.task;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.jar.Attributes;
import java.util.jar.Manifest;
import javax.inject.Inject;
import net.fabricmc.loom.LoomGradleExtension;
import net.fabricmc.loom.api.mappings.layered.MappingsNamespace;
import net.fabricmc.loom.task.service.ClientEntriesService;
import net.fabricmc.loom.task.service.JarManifestService;
import net.fabricmc.loom.util.Check;
import net.fabricmc.loom.util.ExceptionUtil;
import net.fabricmc.loom.util.ZipReprocessorUtil;
import net.fabricmc.loom.util.ZipUtils;
import net.fabricmc.loom.util.gradle.SourceSetHelper;
import net.fabricmc.loom.util.service.ScopedServiceFactory;
import org.gradle.api.Action;
import org.gradle.api.file.ConfigurableFileCollection;
import org.gradle.api.file.RegularFile;
import org.gradle.api.file.RegularFileProperty;
import org.gradle.api.provider.ListProperty;
import org.gradle.api.provider.MapProperty;
import org.gradle.api.provider.Property;
import org.gradle.api.provider.Provider;
import org.gradle.api.tasks.Classpath;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.InputFile;
import org.gradle.api.tasks.InputFiles;
import org.gradle.api.tasks.Nested;
import org.gradle.api.tasks.Optional;
import org.gradle.api.tasks.PathSensitive;
import org.gradle.api.tasks.PathSensitivity;
import org.gradle.api.tasks.SourceSet;
import org.gradle.api.tasks.bundling.ZipEntryCompression;
import org.gradle.jvm.tasks.Jar;
import org.gradle.work.DisableCachingByDefault;
import org.gradle.workers.WorkAction;
import org.gradle.workers.WorkParameters;
import org.gradle.workers.WorkQueue;
import org.gradle.workers.WorkerExecutor;
import org.jetbrains.annotations.ApiStatus;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@DisableCachingByDefault(because="Jar task cannot be cached")
public abstract class AbstractRemapJarTask
extends Jar {
    private final Provider<JarManifestService> jarManifestServiceProvider;

    @PathSensitive(value=PathSensitivity.NONE)
    @InputFile
    public abstract RegularFileProperty getInputFile();

    @Classpath
    public abstract ConfigurableFileCollection getClasspath();

    @Input
    public abstract Property<String> getSourceNamespace();

    @Input
    public abstract Property<String> getTargetNamespace();

    @Inject
    protected abstract WorkerExecutor getWorkerExecutor();

    @Input
    public abstract Property<Boolean> getIncludesClientOnlyClasses();

    @Input
    public abstract ListProperty<String> getAdditionalClientOnlyEntries();

    @Input
    @Optional
    public abstract Property<String> getClientOnlySourceSetName();

    @InputFiles
    @PathSensitive(value=PathSensitivity.NONE)
    @Optional
    @ApiStatus.Experimental
    public abstract ConfigurableFileCollection getCustomMappings();

    @Input
    @Optional
    @ApiStatus.Internal
    public abstract Property<String> getJarType();

    @Nested
    @Optional
    protected abstract Property<ClientEntriesService.Options> getClientEntriesServiceOptions();

    @Inject
    public AbstractRemapJarTask() {
        this.from(new Object[]{this.getProject().zipTree((Object)this.getInputFile())});
        this.getSourceNamespace().convention((Object)MappingsNamespace.NAMED.toString()).finalizeValueOnRead();
        this.getTargetNamespace().convention((Object)MappingsNamespace.INTERMEDIARY.toString()).finalizeValueOnRead();
        this.getIncludesClientOnlyClasses().convention((Object)false).finalizeValueOnRead();
        this.getJarType().finalizeValueOnRead();
        this.getClientEntriesServiceOptions().set(this.getIncludesClientOnlyClasses().flatMap(clientOnlyEntries -> {
            if (clientOnlyEntries.booleanValue()) {
                return this.getClientOnlyEntriesOptionsProvider(this.getClientSourceSet());
            }
            return this.getProject().getObjects().property(ClientEntriesService.Options.class);
        }));
        this.jarManifestServiceProvider = JarManifestService.get(this.getProject());
        this.usesService(this.jarManifestServiceProvider);
    }

    public final <P extends AbstractRemapParams> void submitWork(Class<? extends AbstractRemapAction<P>> workAction, Action<P> action) {
        WorkQueue workQueue = this.getWorkerExecutor().noIsolation();
        workQueue.submit(workAction, params -> {
            params.getInputFile().set((Provider)this.getInputFile());
            params.getArchiveFile().set(this.getArchiveFile());
            params.getSourceNamespace().set(this.getSourceNamespace());
            params.getTargetNamespace().set(this.getTargetNamespace());
            params.getArchivePreserveFileTimestamps().set((Object)this.isPreserveFileTimestamps());
            params.getArchiveReproducibleFileOrder().set((Object)this.isReproducibleFileOrder());
            params.getJarManifestService().set(this.jarManifestServiceProvider);
            params.getEntryCompression().set((Object)this.getEntryCompression());
            if (((Boolean)this.getIncludesClientOnlyClasses().get()).booleanValue()) {
                ArrayList<String> clientOnlyEntries;
                try (ScopedServiceFactory serviceFactory = new ScopedServiceFactory();){
                    ClientEntriesService service = (ClientEntriesService)serviceFactory.get(this.getClientEntriesServiceOptions());
                    clientOnlyEntries = new ArrayList<String>(service.getClientOnlyEntries());
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
                clientOnlyEntries.addAll((Collection)this.getAdditionalClientOnlyEntries().get());
                Collections.sort(clientOnlyEntries);
                this.applyClientOnlyManifestAttributes((AbstractRemapParams)params, (List<String>)clientOnlyEntries);
                params.getClientOnlyEntries().set(clientOnlyEntries.stream().filter(s -> s.endsWith(".class")).toList());
            }
            if (this.getJarType().isPresent()) {
                params.getManifestAttributes().put((Object)"Fabric-Jar-Type", (Object)((String)this.getJarType().get()));
            }
            action.execute(params);
        });
    }

    protected abstract Provider<? extends ClientEntriesService.Options> getClientOnlyEntriesOptionsProvider(SourceSet var1);

    protected void applyClientOnlyManifestAttributes(AbstractRemapParams params, List<String> entries) {
        params.getManifestAttributes().set(Map.of("Fabric-Loom-Split-Environment", "true", "Fabric-Loom-Client-Only-Entries", String.join((CharSequence)";", entries)));
    }

    @Deprecated
    @InputFile
    @PathSensitive(value=PathSensitivity.NONE)
    public RegularFileProperty getInput() {
        return this.getInputFile();
    }

    private SourceSet getClientSourceSet() {
        Check.require(LoomGradleExtension.get(this.getProject()).areEnvironmentSourceSetsSplit(), "Cannot get client sourceset as project is not split");
        return SourceSetHelper.getSourceSetByName((String)this.getClientOnlySourceSetName().get(), this.getProject());
    }

    public static interface AbstractRemapParams
    extends WorkParameters {
        public RegularFileProperty getInputFile();

        public RegularFileProperty getArchiveFile();

        public Property<String> getSourceNamespace();

        public Property<String> getTargetNamespace();

        default public boolean namespacesMatch() {
            return ((String)this.getSourceNamespace().get()).equals(this.getTargetNamespace().get());
        }

        public Property<Boolean> getArchivePreserveFileTimestamps();

        public Property<Boolean> getArchiveReproducibleFileOrder();

        public Property<ZipEntryCompression> getEntryCompression();

        public Property<JarManifestService> getJarManifestService();

        public MapProperty<String, String> getManifestAttributes();

        public ListProperty<String> getClientOnlyEntries();
    }

    public static abstract class AbstractRemapAction<T extends AbstractRemapParams>
    implements WorkAction<T> {
        private static final Logger LOGGER = LoggerFactory.getLogger(AbstractRemapAction.class);
        protected final Path outputFile = ((File)((AbstractRemapParams)this.getParameters()).getArchiveFile().getAsFile().get()).toPath();

        @Inject
        public AbstractRemapAction() {
        }

        public final void execute() {
            try {
                Path tempInput = Files.createTempFile("loom-remapJar-", "-input.jar", new FileAttribute[0]);
                Files.copy(this.outputFile, tempInput, StandardCopyOption.REPLACE_EXISTING);
                this.execute(tempInput);
                Files.delete(tempInput);
            }
            catch (Exception e) {
                try {
                    Files.deleteIfExists(this.outputFile);
                }
                catch (IOException ex) {
                    LOGGER.error("Failed to delete output file", (Throwable)ex);
                }
                throw ExceptionUtil.createDescriptiveWrapper(RuntimeException::new, "Failed to remap " + String.valueOf(this.outputFile.toAbsolutePath()), e);
            }
        }

        protected abstract void execute(Path var1) throws IOException;

        protected void modifyJarManifest() throws IOException {
            int count = ZipUtils.transform(this.outputFile, Map.of("META-INF/MANIFEST.MF", bytes -> {
                Manifest manifest = new Manifest(new ByteArrayInputStream((byte[])bytes));
                byte[] sourceManifestBytes = ZipUtils.unpackNullable(((RegularFile)((AbstractRemapParams)this.getParameters()).getInputFile().get()).getAsFile().toPath(), "META-INF/MANIFEST.MF");
                if (sourceManifestBytes != null) {
                    Manifest sourceManifest = new Manifest(new ByteArrayInputStream(sourceManifestBytes));
                    AbstractRemapAction.mergeManifests(manifest, sourceManifest);
                }
                ((JarManifestService)((AbstractRemapParams)this.getParameters()).getJarManifestService().get()).apply(manifest, (Map)((AbstractRemapParams)this.getParameters()).getManifestAttributes().get());
                manifest.getMainAttributes().putValue("Fabric-Mapping-Namespace", (String)((AbstractRemapParams)this.getParameters()).getTargetNamespace().get());
                ByteArrayOutputStream out = new ByteArrayOutputStream();
                manifest.write(out);
                return out.toByteArray();
            }));
            Check.require(count > 0, "Did not transform any jar manifest");
        }

        protected void rewriteJar() throws IOException {
            boolean isReproducibleFileOrder = (Boolean)((AbstractRemapParams)this.getParameters()).getArchiveReproducibleFileOrder().get();
            boolean isPreserveFileTimestamps = (Boolean)((AbstractRemapParams)this.getParameters()).getArchivePreserveFileTimestamps().get();
            ZipEntryCompression compression = (ZipEntryCompression)((AbstractRemapParams)this.getParameters()).getEntryCompression().get();
            if (isReproducibleFileOrder || !isPreserveFileTimestamps || compression != ZipEntryCompression.DEFLATED) {
                ZipReprocessorUtil.reprocessZip(this.outputFile, isReproducibleFileOrder, isPreserveFileTimestamps, compression);
            }
        }

        private static void mergeManifests(Manifest target, Manifest source) {
            AbstractRemapAction.mergeAttributes(target.getMainAttributes(), source.getMainAttributes());
            source.getEntries().forEach((name, sourceAttributes) -> {
                Attributes targetAttributes = target.getAttributes((String)name);
                if (targetAttributes != null) {
                    AbstractRemapAction.mergeAttributes(targetAttributes, sourceAttributes);
                } else {
                    target.getEntries().put((String)name, (Attributes)sourceAttributes);
                }
            });
        }

        private static void mergeAttributes(Attributes target, Attributes source) {
            source.forEach(target::putIfAbsent);
        }
    }
}

