/*
 * Decompiled with CFR 0.152.
 */
package net.fabricmc.loom.task.launch;

import com.google.gson.Gson;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import javax.inject.Inject;
import net.fabricmc.loom.LoomGradlePlugin;
import net.fabricmc.loom.configuration.classpathgroups.ExternalClasspathGroupDTO;
import net.fabricmc.loom.task.AbstractLoomTask;
import org.gradle.api.UncheckedIOException;
import org.gradle.api.file.RegularFileProperty;
import org.gradle.api.provider.Property;
import org.gradle.api.provider.Provider;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.OutputFile;
import org.gradle.api.tasks.TaskAction;
import org.gradle.work.DisableCachingByDefault;
import org.gradle.workers.WorkAction;
import org.gradle.workers.WorkParameters;
import org.gradle.workers.WorkQueue;
import org.gradle.workers.WorkerExecutor;

@DisableCachingByDefault
public abstract class ExportClasspathTask
extends AbstractLoomTask {
    @Input
    public abstract Property<String> getClasspathDtoJson();

    @OutputFile
    public abstract RegularFileProperty getOutput();

    @Inject
    protected abstract WorkerExecutor getWorkerExecutor();

    @Inject
    public ExportClasspathTask() {
        this.getClasspathDtoJson().set(this.getProject().provider(() -> ExternalClasspathGroupDTO.createFromProject(this.getProject())).map(arg_0 -> ((Gson)LoomGradlePlugin.GSON).toJson(arg_0)));
        this.getOutput().set(this.getProject().getLayout().getBuildDirectory().file("export_classpath.json"));
    }

    @TaskAction
    public void run() {
        WorkQueue workQueue = this.getWorkerExecutor().noIsolation();
        workQueue.submit(ExportClassPathWorkAction.class, p -> {
            p.getClasspathDtoJson().set(this.getClasspathDtoJson());
            p.getOutput().set((Provider)this.getOutput());
        });
    }

    public static abstract class ExportClassPathWorkAction
    implements WorkAction<ExportClassPathWorkParameters> {
        public void execute() {
            File outputFile = (File)((ExportClassPathWorkParameters)this.getParameters()).getOutput().getAsFile().get();
            String json = (String)((ExportClassPathWorkParameters)this.getParameters()).getClasspathDtoJson().get();
            try {
                Files.writeString(outputFile.toPath(), (CharSequence)json, new OpenOption[0]);
            }
            catch (IOException e) {
                throw new UncheckedIOException("Failed to write classpath groups", (Throwable)e);
            }
        }
    }

    protected static interface ExportClassPathWorkParameters
    extends WorkParameters {
        public Property<String> getClasspathDtoJson();

        public RegularFileProperty getOutput();
    }
}

