/*
 * Decompiled with CFR 0.152.
 */
package net.fabricmc.loom.task.service;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.IOException;
import java.io.Reader;
import java.io.UncheckedIOException;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import net.fabricmc.loom.LoomGradleExtension;
import net.fabricmc.loom.api.mappings.layered.MappingsNamespace;
import net.fabricmc.loom.configuration.ConfigContextImpl;
import net.fabricmc.loom.configuration.processors.MappingProcessorContextImpl;
import net.fabricmc.loom.configuration.processors.MinecraftJarProcessorManager;
import net.fabricmc.loom.task.GenerateSourcesTask;
import net.fabricmc.loom.util.service.ScopedServiceFactory;
import net.fabricmc.loom.util.service.Service;
import net.fabricmc.loom.util.service.ServiceFactory;
import net.fabricmc.loom.util.service.ServiceType;
import net.fabricmc.mappingio.MappingReader;
import net.fabricmc.mappingio.MappingVisitor;
import net.fabricmc.mappingio.adapter.MappingSourceNsSwitch;
import net.fabricmc.mappingio.format.tiny.Tiny2FileWriter;
import net.fabricmc.mappingio.tree.MemoryMappingTree;
import org.gradle.api.Action;
import org.gradle.api.Project;
import org.gradle.api.file.RegularFileProperty;
import org.gradle.api.provider.Property;
import org.gradle.api.provider.Provider;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.InputFile;
import org.gradle.api.tasks.Optional;
import org.gradle.api.tasks.PathSensitive;
import org.gradle.api.tasks.PathSensitivity;
import org.jspecify.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SourceMappingsService
extends Service<Options> {
    public static final ServiceType<Options, SourceMappingsService> TYPE = new ServiceType<Options, SourceMappingsService>(Options.class, SourceMappingsService.class);
    private static final Logger LOGGER = LoggerFactory.getLogger(SourceMappingsService.class);

    public static Provider<Options> create(Project project) {
        Property hash = project.getObjects().property(String.class);
        Path mappings = SourceMappingsService.getMappings(project, (Property<String>)hash);
        return TYPE.create(project, (Action<Options>)((Action)options -> {
            options.getMappings().fileValue(project.file((Object)mappings));
            options.getProcessorHash().set((Provider)hash);
        }));
    }

    private static Path getMappings(Project project, Property<String> hashProperty) {
        LoomGradleExtension extension = LoomGradleExtension.get(project);
        MinecraftJarProcessorManager jarProcessor = MinecraftJarProcessorManager.create(project);
        if (jarProcessor == null) {
            LOGGER.info("No jar processor found, not creating source mappings, using project mappings");
            return extension.getMappingConfiguration().tinyMappings;
        }
        String hash = jarProcessor.getSourceMappingsHash();
        hashProperty.set((Object)hash);
        Path dir = extension.getFiles().getProjectPersistentCache().toPath().resolve("source_mappings");
        Path path = dir.resolve(hash + ".tiny");
        if (Files.exists(path, new LinkOption[0]) && !extension.refreshDeps()) {
            LOGGER.debug("Using cached source mappings");
            return path;
        }
        LOGGER.info("Creating source mappings for hash {}", (Object)jarProcessor.getSourceMappingsHash());
        try {
            Files.createDirectories(dir, new FileAttribute[0]);
            Files.deleteIfExists(path);
            SourceMappingsService.createMappings(project, jarProcessor, path);
        }
        catch (IOException e) {
            throw new UncheckedIOException("Failed to create source mappings", e);
        }
        return path;
    }

    private static void createMappings(Project project, MinecraftJarProcessorManager jarProcessor, Path outputMappings) throws IOException {
        LoomGradleExtension extension = LoomGradleExtension.get(project);
        Path inputMappings = extension.getMappingConfiguration().tinyMappings;
        MemoryMappingTree mappingTree = new MemoryMappingTree();
        try (BufferedReader reader = Files.newBufferedReader(inputMappings, StandardCharsets.UTF_8);){
            MappingReader.read((Reader)reader, (MappingVisitor)new MappingSourceNsSwitch((MappingVisitor)mappingTree, (Boolean)extension.getUseIntermediateMappings().get() != false ? MappingsNamespace.INTERMEDIARY.toString() : MappingsNamespace.OFFICIAL.toString()));
        }
        GenerateSourcesTask.MappingsProcessor mappingsProcessor = mappings -> {
            boolean bl;
            ScopedServiceFactory serviceFactory = new ScopedServiceFactory();
            try {
                ConfigContextImpl configContext = new ConfigContextImpl(project, serviceFactory, extension);
                bl = jarProcessor.processMappings(mappings, new MappingProcessorContextImpl(configContext));
            }
            catch (Throwable throwable) {
                try {
                    try {
                        serviceFactory.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw new UncheckedIOException(e);
                }
            }
            serviceFactory.close();
            return bl;
        };
        boolean transformed = mappingsProcessor.transform(mappingTree);
        if (!transformed) {
            LOGGER.info("No mappings processors transformed the mappings");
        }
        try (BufferedWriter writer = Files.newBufferedWriter(outputMappings, StandardCharsets.UTF_8, new OpenOption[0]);){
            Tiny2FileWriter tiny2Writer = new Tiny2FileWriter((Writer)writer, false);
            mappingTree.accept((MappingVisitor)new MappingSourceNsSwitch((MappingVisitor)tiny2Writer, MappingsNamespace.NAMED.toString()));
        }
    }

    public SourceMappingsService(Options options, ServiceFactory serviceFactory) {
        super(options, serviceFactory);
    }

    public Path getMappingsFile() {
        return ((File)((Options)this.getOptions()).getMappings().getAsFile().get()).toPath();
    }

    public @Nullable String getProcessorHash() {
        return (String)((Options)this.getOptions()).getProcessorHash().getOrNull();
    }

    public static interface Options
    extends Service.Options {
        @InputFile
        @PathSensitive(value=PathSensitivity.NONE)
        public RegularFileProperty getMappings();

        @Input
        @Optional
        public Property<String> getProcessorHash();
    }
}

