/*
 * Decompiled with CFR 0.152.
 */
package net.fabricmc.loom.configuration.ide.idea;

import java.util.ArrayList;
import java.util.List;
import javax.inject.Inject;
import net.fabricmc.loom.LoomGradleExtension;
import net.fabricmc.loom.configuration.ide.RunConfigSettings;
import net.fabricmc.loom.configuration.ide.idea.IdeaSyncTask;
import net.fabricmc.loom.configuration.ide.idea.IdeaUtils;
import net.fabricmc.loom.task.LoomTasks;
import org.gradle.StartParameter;
import org.gradle.api.Project;
import org.gradle.internal.DefaultTaskExecutionRequest;

public abstract class IdeaConfiguration
implements Runnable {
    @Inject
    protected abstract Project getProject();

    @Override
    public void run() {
        this.getProject().getTasks().register("ideaSyncTask", IdeaSyncTask.class, task -> {
            if (LoomGradleExtension.get(this.getProject()).getRunConfigs().stream().anyMatch(RunConfigSettings::isIdeConfigGenerated)) {
                task.dependsOn(new Object[]{LoomTasks.getIDELaunchConfigureTaskName(this.getProject())});
            } else {
                task.setEnabled(false);
            }
        });
        if (!IdeaUtils.isIdeaSync()) {
            return;
        }
        StartParameter startParameter = this.getProject().getGradle().getStartParameter();
        ArrayList<DefaultTaskExecutionRequest> taskRequests = new ArrayList<DefaultTaskExecutionRequest>(startParameter.getTaskRequests());
        taskRequests.add(new DefaultTaskExecutionRequest(List.of("ideaSyncTask")));
        startParameter.setTaskRequests(taskRequests);
    }
}

