/*
 * Decompiled with CFR 0.152.
 */
package net.fabricmc.loom.configuration.processors.speccontext;

import java.io.File;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Stream;
import net.fabricmc.loom.api.mappings.layered.MappingsNamespace;
import net.fabricmc.loom.api.processor.SpecContext;
import net.fabricmc.loom.configuration.processors.speccontext.DebofConfiguration;
import net.fabricmc.loom.configuration.processors.speccontext.DeobfProjectView;
import net.fabricmc.loom.util.AsyncCache;
import net.fabricmc.loom.util.fmj.FabricModJson;
import net.fabricmc.loom.util.fmj.FabricModJsonFactory;
import net.fabricmc.loom.util.fmj.FabricModJsonHelpers;
import org.gradle.api.Project;
import org.gradle.api.file.FileCollection;

public record DeobfSpecContext(List<FabricModJson> modDependencies, List<FabricModJson> localMods, List<FabricModJson> modDependenciesCompileRuntime, List<FabricModJson> modDependenciesCompileRuntimeClient) implements SpecContext
{
    public static DeobfSpecContext create(Project project) {
        return DeobfSpecContext.create(new DeobfProjectView.Impl(project));
    }

    public static DeobfSpecContext create(DeobfProjectView projectView) {
        Set<String> clientTransformingModIds;
        List<FabricModJson> clientCompileMods;
        List<FabricModJson> clientRuntimeMods;
        AsyncCache<List<FabricModJson>> fmjCache = new AsyncCache<List<FabricModJson>>();
        FileCollection mainRuntimeClasspath = projectView.getDependencies(DebofConfiguration.RUNTIME, DebofConfiguration.TargetSourceSet.MAIN);
        FileCollection mainCompileClasspath = projectView.getDependencies(DebofConfiguration.COMPILE, DebofConfiguration.TargetSourceSet.MAIN);
        List<FabricModJson> mainRuntimeMods = DeobfSpecContext.getModsFromConfiguration(mainRuntimeClasspath, fmjCache);
        List<FabricModJson> mainCompileMods = DeobfSpecContext.getModsFromConfiguration(mainCompileClasspath, fmjCache);
        Set<String> mainRuntimeModIds = DeobfSpecContext.toModIdSet(mainRuntimeMods);
        Set<String> mainCompileModIds = DeobfSpecContext.toModIdSet(mainCompileMods);
        Set<String> mainTransformingModIds = DeobfSpecContext.common(mainRuntimeModIds, mainCompileModIds);
        if (projectView.areEnvironmentSourceSetsSplit()) {
            FileCollection clientRuntimeClasspath = projectView.getDependencies(DebofConfiguration.RUNTIME, DebofConfiguration.TargetSourceSet.CLIENT);
            FileCollection clientCompileClasspath = projectView.getDependencies(DebofConfiguration.COMPILE, DebofConfiguration.TargetSourceSet.CLIENT);
            clientRuntimeMods = DeobfSpecContext.getModsFromConfiguration(clientRuntimeClasspath, fmjCache);
            clientCompileMods = DeobfSpecContext.getModsFromConfiguration(clientCompileClasspath, fmjCache);
            Set<String> clientRuntimeModIds = DeobfSpecContext.toModIdSet(clientRuntimeMods);
            Set<String> clientCompileModIds = DeobfSpecContext.toModIdSet(clientCompileMods);
            clientTransformingModIds = DeobfSpecContext.common(clientRuntimeModIds, clientCompileModIds);
        } else {
            clientRuntimeMods = List.of();
            clientCompileMods = List.of();
            clientTransformingModIds = Set.of();
        }
        ArrayList<FabricModJson> allMods = new ArrayList<FabricModJson>();
        allMods.addAll(mainRuntimeMods);
        allMods.addAll(mainCompileMods);
        allMods.addAll(clientRuntimeMods);
        allMods.addAll(clientCompileMods);
        if (!projectView.disableProjectDependantMods()) {
            for (Project dependentProject : SpecContext.getDependentProjects(projectView).toList()) {
                allMods.addAll(fmjCache.getBlocking(dependentProject.getPath(), () -> FabricModJsonHelpers.getModsInProject(dependentProject)));
            }
        }
        List<FabricModJson> dependentMods = SpecContext.distinctSorted(allMods);
        Map mods = dependentMods.stream().collect(HashMap::new, (map, mod) -> map.put(mod.getId(), mod), Map::putAll);
        ArrayList<FabricModJson> modDependenciesCompileRuntime = new ArrayList<FabricModJson>(DeobfSpecContext.getMods(mods, DeobfSpecContext.combine(mainTransformingModIds, clientTransformingModIds)));
        modDependenciesCompileRuntime.addAll(DeobfSpecContext.getCompileRuntimeProjectMods(projectView, fmjCache));
        return new DeobfSpecContext(dependentMods, projectView.getMods(), modDependenciesCompileRuntime, DeobfSpecContext.getMods(mods, DeobfSpecContext.onlyInLeft(clientTransformingModIds, mainTransformingModIds)));
    }

    private static List<FabricModJson> getDependentMods(DeobfProjectView projectView, AsyncCache<List<FabricModJson>> fmjCache) {
        ArrayList futures = new ArrayList();
        for (File artifact : projectView.getFullClasspath().getFiles()) {
            futures.add(fmjCache.get(artifact.toPath().toAbsolutePath().toString(), () -> DeobfSpecContext.getMod(artifact.toPath()).map(List::of).orElseGet(List::of)));
        }
        if (!projectView.disableProjectDependantMods()) {
            for (Project dependentProject : SpecContext.getDependentProjects(projectView).toList()) {
                futures.add(fmjCache.get(dependentProject.getPath(), () -> FabricModJsonHelpers.getModsInProject(dependentProject)));
            }
        }
        return SpecContext.distinctSorted(AsyncCache.joinList(futures));
    }

    private static List<FabricModJson> getModsFromConfiguration(FileCollection configuration, AsyncCache<List<FabricModJson>> fmjCache) {
        ArrayList futures = new ArrayList();
        for (File artifact : configuration.getFiles()) {
            futures.add(fmjCache.get(artifact.toPath().toAbsolutePath().toString(), () -> DeobfSpecContext.getMod(artifact.toPath()).map(List::of).orElseGet(List::of)));
        }
        return SpecContext.distinctSorted(AsyncCache.joinList(futures));
    }

    private static Set<String> toModIdSet(List<FabricModJson> mods) {
        return mods.stream().map(FabricModJson::getId).collect(HashSet::new, Set::add, Set::addAll);
    }

    private static Optional<FabricModJson> getMod(Path path) {
        if (Files.isRegularFile(path, new LinkOption[0])) {
            return FabricModJsonFactory.createFromZipOptional(path);
        }
        return Optional.empty();
    }

    private static List<FabricModJson> getMods(Map<String, FabricModJson> mods, Set<String> ids) {
        ArrayList<FabricModJson> result = new ArrayList<FabricModJson>();
        for (String id : ids) {
            result.add(Objects.requireNonNull(mods.get(id), "Could not find mod with id: " + id));
        }
        return result;
    }

    private static List<FabricModJson> getCompileRuntimeProjectMods(DeobfProjectView projectView, AsyncCache<List<FabricModJson>> fmjCache) {
        ArrayList mods = new ArrayList();
        for (Project dependentProject : DeobfSpecContext.getCompileRuntimeProjectDependencies(projectView).toList()) {
            List projectMods = fmjCache.getBlocking(dependentProject.getPath(), () -> FabricModJsonHelpers.getModsInProject(dependentProject));
            mods.addAll(projectMods);
        }
        return Collections.unmodifiableList(mods);
    }

    private static Stream<Project> getCompileRuntimeProjectDependencies(DeobfProjectView projectView) {
        if (projectView.disableProjectDependantMods()) {
            return Stream.empty();
        }
        Stream<Project> runtimeProjects = projectView.getProjectDependencies(DebofConfiguration.RUNTIME);
        List<Project> compileProjects = projectView.getProjectDependencies(DebofConfiguration.COMPILE).toList();
        return runtimeProjects.filter(compileProjects::contains);
    }

    private static Set<String> common(Set<String> a, Set<String> b) {
        HashSet<String> copy = new HashSet<String>(a);
        copy.retainAll(b);
        return copy;
    }

    private static Set<String> combine(Set<String> a, Set<String> b) {
        HashSet<String> copy = new HashSet<String>(a);
        copy.addAll(b);
        return copy;
    }

    private static Set<String> onlyInLeft(Set<String> left, Set<String> right) {
        HashSet<String> copy = new HashSet<String>(left);
        copy.removeAll(right);
        return copy;
    }

    @Override
    public MappingsNamespace productionNamespace() {
        return MappingsNamespace.OFFICIAL;
    }
}

