/*
 * Decompiled with CFR 0.152.
 */
package net.fabricmc.meta.data;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import javax.xml.stream.XMLStreamException;
import net.fabricmc.meta.utils.MinecraftLauncherMeta;
import net.fabricmc.meta.utils.PomParser;
import net.fabricmc.meta.utils.Reference;
import net.fabricmc.meta.web.models.BaseVersion;
import net.fabricmc.meta.web.models.LegacyDbDump;
import net.fabricmc.meta.web.models.MavenBuildGameVersion;
import net.fabricmc.meta.web.models.MavenBuildVersion;
import net.fabricmc.meta.web.models.MavenUrlVersion;
import net.fabricmc.meta.web.models.MavenVersion;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class VersionDatabase {
    private static final PomParser MAPPINGS_PARSER = new PomParser(Reference.LOCAL_FABRIC_MAVEN_URL + "net/fabricmc/yarn/maven-metadata.xml");
    private static final PomParser INTERMEDIARY_PARSER = new PomParser(Reference.LOCAL_FABRIC_MAVEN_URL + "net/fabricmc/intermediary/maven-metadata.xml");
    private static final PomParser LOADER_PARSER = new PomParser(Reference.LOCAL_FABRIC_MAVEN_URL + "net/fabricmc/fabric-loader/maven-metadata.xml");
    private static final PomParser INSTALLER_PARSER = new PomParser(Reference.LOCAL_FABRIC_MAVEN_URL + "net/fabricmc/fabric-installer/maven-metadata.xml");
    private static final Set<String> incorrectIntermediaryVersions = new HashSet<String>();
    private static final Logger LOGGER = LoggerFactory.getLogger(VersionDatabase.class);
    private Map<String, GameVersionData> gameVersionIndex;
    private List<BaseVersion> gameModels;
    private List<MavenVersion> intermediaries;
    private List<MavenBuildGameVersion> yarns;
    private List<MavenBuildVersion> loader;
    public List<MavenUrlVersion> installer;

    private VersionDatabase() {
    }

    public static VersionDatabase generate(boolean initial) throws IOException, XMLStreamException {
        long start2 = System.nanoTime();
        VersionDatabase database = new VersionDatabase();
        database.yarns = MAPPINGS_PARSER.getMeta(MavenBuildGameVersion::new, "net.fabricmc:yarn:");
        database.intermediaries = INTERMEDIARY_PARSER.getMeta(MavenVersion::new, "net.fabricmc:intermediary:");
        database.loader = LOADER_PARSER.getMeta(MavenBuildVersion::new, "net.fabricmc:fabric-loader:", list -> {
            for (BaseVersion version : list) {
                if (!VersionDatabase.isPublicLoaderVersion(version)) continue;
                version.setStable(true);
                break;
            }
        });
        database.installer = INSTALLER_PARSER.getMeta(MavenUrlVersion::new, "net.fabricmc:fabric-installer:");
        database.loadMcData(initial);
        LOGGER.info("DB update took {} ms", (Object)((System.nanoTime() - start2) / 1000000L));
        return database;
    }

    private void loadMcData(boolean initial) throws IOException {
        if (this.yarns == null || this.intermediaries == null) {
            throw new RuntimeException("Mappings are null");
        }
        MinecraftLauncherMeta launcherMeta = MinecraftLauncherMeta.getAllMeta(initial);
        ArrayList<MavenVersion> newIntermediary = new ArrayList<MavenVersion>();
        HashMap<String, MavenVersion> intermediaryIndex = new HashMap<String, MavenVersion>();
        for (MavenVersion v : this.intermediaries) {
            if (launcherMeta.getVersion(v.getVersion()) == null) {
                if (!incorrectIntermediaryVersions.add(v.getVersion())) continue;
                LOGGER.warn("Removing intermediary for {} as it doesn't match a valid mc version", (Object)v.getVersion());
                continue;
            }
            v.setStable(true);
            newIntermediary.add(v);
            intermediaryIndex.put(v.getVersion(), v);
        }
        newIntermediary.sort(Comparator.comparingInt(o -> launcherMeta.getIndex(o.getVersion())));
        this.intermediaries = newIntermediary;
        HashMap yarnIndex = new HashMap();
        for (MavenBuildGameVersion v : this.yarns) {
            yarnIndex.computeIfAbsent(v.getGameVersion(), ignore -> new ArrayList()).add(v);
        }
        this.gameVersionIndex = new HashMap<String, GameVersionData>(launcherMeta.getVersions().size());
        this.gameModels = new ArrayList<BaseVersion>(launcherMeta.getVersions().size());
        for (MinecraftLauncherMeta.Version version : launcherMeta.getVersions()) {
            MavenVersion intermediary = (MavenVersion)intermediaryIndex.get(version.id());
            if (intermediary == null && !version.obfuscated()) {
                intermediary = Reference.NOOP_INTERMEDIARY_VERSION;
            }
            if (intermediary == null) continue;
            BaseVersion exposedModel = new BaseVersion(version.id(), version.isStable());
            List<MavenBuildGameVersion> versionYarns = yarnIndex.getOrDefault(version.id(), Collections.emptyList());
            this.gameVersionIndex.put(version.id(), new GameVersionData(version, this.gameModels.size(), exposedModel, intermediary, versionYarns));
            this.gameModels.add(exposedModel);
        }
    }

    public GameVersionData getGameData(String version) {
        return this.gameVersionIndex.get(version);
    }

    public List<BaseVersion> getGameModels() {
        return this.gameModels;
    }

    public List<MavenVersion> getIntermediaryModels() {
        return this.intermediaries;
    }

    public List<MavenBuildGameVersion> getYarnModels() {
        return this.yarns;
    }

    public MavenBuildVersion getLoader(String version) {
        for (MavenBuildVersion v : this.loader) {
            if (!v.getVersion().equals(version)) continue;
            return v;
        }
        return null;
    }

    public List<MavenBuildVersion> getLoader() {
        return this.loader.stream().filter(VersionDatabase::isPublicLoaderVersion).collect(Collectors.toList());
    }

    private static boolean isPublicLoaderVersion(BaseVersion version) {
        return true;
    }

    public List<MavenBuildVersion> getAllLoader() {
        return this.loader;
    }

    public LegacyDbDump createLegacyDbDump() {
        return new LegacyDbDump(this.gameModels, this.yarns, this.intermediaries, this.loader, this.installer);
    }

    public record GameVersionData(MinecraftLauncherMeta.Version version, int index, BaseVersion exposedModel, MavenVersion intermediary, List<MavenBuildGameVersion> yarn) {
    }
}

