/*
 * Decompiled with CFR 0.152.
 */
package net.fabricmc.meta.web;

import io.javalin.http.BadRequestResponse;
import io.javalin.http.Context;
import io.javalin.http.Handler;
import io.javalin.http.InternalServerErrorResponse;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.nio.charset.StandardCharsets;
import java.nio.file.CopyOption;
import java.nio.file.FileSystem;
import java.nio.file.FileSystems;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.concurrent.Executors;
import net.fabricmc.meta.FabricMeta;
import net.fabricmc.meta.utils.Reference;
import net.fabricmc.meta.web.WebServer;
import net.fabricmc.meta.web.models.BaseVersion;
import org.apache.commons.io.FileUtils;

public class ServerBootstrap {
    private static final Path CACHE_DIR = Paths.get("metadata", "installer");
    private static final Executor WORKER_EXECUTOR = Executors.newSingleThreadExecutor();

    public static void setup() {
        WebServer.javalin.get("/v2/versions/loader/{game_version}/{loader_version}/{installer_version}/server/jar", ServerBootstrap.boostrapHandler());
    }

    private static Handler boostrapHandler() {
        return ctx -> {
            if (!ctx.queryParamMap().isEmpty()) {
                throw new BadRequestResponse("Query params not allowed on this endpoint.");
            }
            String installerVersion = ServerBootstrap.getAndValidateVersion(ctx, FabricMeta.database.installer, "installer_version");
            String gameVersion = ServerBootstrap.getAndValidateVersion(ctx, FabricMeta.database.getGameModels(), "game_version");
            String loaderVersion = ServerBootstrap.getAndValidateVersion(ctx, FabricMeta.database.getAllLoader(), "loader_version");
            ServerBootstrap.validateLoaderVersion(loaderVersion);
            ServerBootstrap.validateInstallerVersion(installerVersion);
            String filename = String.format("fabric-server-mc.%s-loader.%s-launcher.%s.jar", gameVersion, loaderVersion, installerVersion);
            ctx.header("Content-Disposition", String.format("attachment; filename=\"%s\"", filename));
            String cacheControl = String.format("public, max-age=%d", ServerBootstrap.getCacheDuration(ctx));
            ctx.header("Cache-Control", cacheControl);
            ctx.contentType("application/java-archive");
            ctx.future(() -> ServerBootstrap.getResultStream(installerVersion, gameVersion, loaderVersion).thenApply(ctx::result));
        };
    }

    private static <V extends BaseVersion> String getAndValidateVersion(Context ctx, List<V> versions, String name) {
        String version = ctx.pathParam(name);
        for (BaseVersion v : versions) {
            if (version.equals("stable") && v.isStable()) {
                return v.getVersion();
            }
            if (!v.getVersion().equals(version)) continue;
            return version;
        }
        throw new BadRequestResponse("Unable to find valid version for " + name);
    }

    private static void validateLoaderVersion(String loaderVersion) {
        String[] versionSplit = loaderVersion.split("\\.");
        if (Integer.parseInt(versionSplit[0]) > 0) {
            return;
        }
        if (Integer.parseInt(versionSplit[1]) >= 12) {
            return;
        }
        throw new BadRequestResponse("Fabric loader 0.12 or higher is required for unattended server installs. Please use a newer fabric loader version, or the full installer.");
    }

    private static void validateInstallerVersion(String installerVersion) {
        String[] versionSplit = installerVersion.split("\\.");
        if (Integer.parseInt(versionSplit[0]) > 0) {
            return;
        }
        if (Integer.parseInt(versionSplit[1]) >= 8) {
            return;
        }
        throw new BadRequestResponse("Fabric Installer 0.8 or higher is required for unattended server installs.");
    }

    private static CompletableFuture<InputStream> getResultStream(String installerVersion, String gameVersion, String loaderVersion) {
        Path bundledJar = CACHE_DIR.resolve(String.format("fabric-server-mc.%s-loader.%s-launcher.%s.jar", gameVersion, loaderVersion, installerVersion));
        if (!Files.exists(bundledJar, new LinkOption[0])) {
            return CompletableFuture.supplyAsync(() -> {
                try {
                    if (!Files.exists(bundledJar, new LinkOption[0])) {
                        Path installerJar = ServerBootstrap.getInstallerJar(installerVersion);
                        ServerBootstrap.writePropertiesToJar(installerJar, bundledJar, loaderVersion, gameVersion);
                    }
                    return Files.newInputStream(bundledJar, new OpenOption[0]);
                }
                catch (IOException e) {
                    e.printStackTrace();
                    throw new InternalServerErrorResponse("Failed to generate bundled jar");
                }
            }, WORKER_EXECUTOR);
        }
        try {
            return CompletableFuture.completedFuture(Files.newInputStream(bundledJar, new OpenOption[0]));
        }
        catch (IOException e) {
            e.printStackTrace();
            throw new InternalServerErrorResponse("Failed to serve bundled jar");
        }
    }

    private static Path getInstallerJar(String installerVersion) throws IOException {
        Path installerJar = CACHE_DIR.resolve(String.format("fabric-installer-%s.jar", installerVersion));
        if (Files.exists(installerJar, new LinkOption[0])) {
            return installerJar;
        }
        return ServerBootstrap.downloadInstallerJar(installerJar, installerVersion);
    }

    private static Path downloadInstallerJar(Path jar, String installerVersion) throws IOException {
        String url2 = String.format(Reference.LOCAL_FABRIC_MAVEN_URL + "net/fabricmc/fabric-installer/%1$s/fabric-installer-%1$s-server.jar", installerVersion);
        System.out.println("Downloading: " + url2);
        FileUtils.copyURLToFile(URI.create(url2).toURL(), jar.toFile());
        return jar;
    }

    private static void writePropertiesToJar(Path inputJar, Path outputJar, String loaderVersion, String gameVersion) throws IOException {
        String data = String.format("fabric-loader-version=%s\ngame-version=%s", loaderVersion, gameVersion);
        Path workingFile = Paths.get(String.valueOf(outputJar.toAbsolutePath()) + ".tmp", new String[0]);
        Files.copy(inputJar, workingFile, new CopyOption[0]);
        HashMap<String, String> env = new HashMap<String, String>();
        env.put("create", "true");
        URI uri = URI.create("jar:" + String.valueOf(workingFile.toUri()));
        try (FileSystem zipFs = FileSystems.newFileSystem(uri, env);){
            Files.write(zipFs.getPath("install.properties", new String[0]), data.getBytes(StandardCharsets.UTF_8), new OpenOption[0]);
        }
        Files.copy(workingFile, outputJar, new CopyOption[0]);
        Files.delete(workingFile);
    }

    private static int getCacheDuration(Context ctx) {
        if (ctx.pathParamMap().containsValue("stable")) {
            return 120;
        }
        return 86400;
    }
}

