/*
 * Decompiled with CFR 0.152.
 */
package net.fabricmc.meta.utils;

import com.google.gson.JsonObject;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import java.net.URI;
import net.fabricmc.meta.utils.Reference;
import net.fabricmc.meta.web.WebServer;
import net.fabricmc.meta.web.models.MavenBuildVersion;
import org.apache.commons.io.FileUtils;

public class LoaderMeta {
    public static final File BASE_DIR = new File("metadata");

    public static synchronized JsonObject getMeta(MavenBuildVersion loader) {
        String loaderMaven = loader.getMaven();
        String[] split = loaderMaven.split(":");
        String path = String.format("%s/%s/%s", split[0].replaceAll("\\.", "/"), split[1], split[2]);
        String filename = String.format("%s-%s.json", split[1], split[2]);
        File launcherMetaFile = new File(BASE_DIR, path + "/" + filename);
        if (!launcherMetaFile.exists()) {
            try {
                String url2 = String.format("%s%s/%s", Reference.LOCAL_FABRIC_MAVEN_URL, path, filename);
                System.out.println("Downloading " + url2);
                FileUtils.copyURLToFile(URI.create(url2).toURL(), launcherMetaFile);
            }
            catch (IOException e) {
                e.printStackTrace();
                return null;
            }
        }
        try {
            JsonObject jsonObject = WebServer.GSON.fromJson((Reader)new FileReader(launcherMetaFile), JsonObject.class);
            return jsonObject;
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
            return null;
        }
    }
}

