/*
 * Decompiled with CFR 0.152.
 */
package net.fabricmc.meta.utils;

import java.io.IOException;
import java.net.URI;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.time.OffsetDateTime;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HexFormat;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.fabricmc.meta.FabricMeta;
import net.fabricmc.meta.data.VersionDatabase;
import net.fabricmc.meta.utils.Reference;
import org.apache.commons.io.IOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MinecraftLauncherMeta {
    private static final boolean EMULATE_OLD = false;
    private static final Set<String> HIGH_PRIORITY_TYPES = Set.of("release", "snapshot");
    private static final String EXTRA_META_URL = System.getProperty("extraMcMetaUrl");
    private static final Logger LOGGER = LoggerFactory.getLogger(VersionDatabase.class);
    private final List<Version> versions;
    private final Map<String, Integer> index;

    private MinecraftLauncherMeta(List<Version> versions) {
        this.versions = versions;
        this.index = new HashMap<String, Integer>(versions.size());
        for (int i = 0; i < versions.size(); ++i) {
            this.index.put(versions.get(i).id(), i);
        }
    }

    private static List<Version> getMeta(String url2, boolean readFromCache, boolean writeToCache) throws IOException {
        Path cacheFile = readFromCache || writeToCache ? FabricMeta.CACHE_DIR.resolve(url2.substring(url2.lastIndexOf(47) + 1)) : null;
        String cachedJson = cacheFile != null && Files.exists(cacheFile, new LinkOption[0]) ? Files.readString(cacheFile) : null;
        try {
            String json = IOUtils.toString(URI.create(url2), StandardCharsets.UTF_8);
            List<Version> ret = MinecraftLauncherMeta.parse(json);
            if (writeToCache) {
                if (ret.isEmpty()) {
                    throw new IOException("received empty version list");
                }
                if (!json.equals(cachedJson)) {
                    Files.createDirectories(cacheFile.toAbsolutePath().getParent(), new FileAttribute[0]);
                    Files.writeString(cacheFile, (CharSequence)json, new OpenOption[0]);
                }
            }
            return ret;
        }
        catch (Exception e) {
            if (readFromCache && cachedJson != null) {
                LOGGER.warn("Error retrieving MC metadata, using local cache: {}", (Object)e.toString());
                return MinecraftLauncherMeta.parse(cachedJson);
            }
            throw e;
        }
    }

    private static List<Version> parse(String json) throws IOException {
        MclMetaVersionManifest parsed = FabricMeta.GSON.fromJson(json, MclMetaVersionManifest.class);
        ArrayList<Version> ret = new ArrayList<Version>(parsed.versions.size());
        for (MclMetaVersionManifest.Version version : parsed.versions) {
            byte[] hash = version.sha1() != null ? HexFormat.of().parseHex(version.sha1()) : null;
            OffsetDateTime time = OffsetDateTime.parse(version.releaseTime());
            boolean obfuscated = FabricMeta.MC_OBFUSCATION_CHECKER.isObfuscated(version.id(), version.url(), hash, time);
            ret.add(new Version(version.id(), version.type(), version.url(), hash, time, obfuscated));
        }
        return ret;
    }

    public static MinecraftLauncherMeta getAllMeta(boolean allowCacheRead) throws IOException {
        ArrayList<Version> versions = new ArrayList<Version>();
        versions.addAll(MinecraftLauncherMeta.getMeta("https://piston-meta.mojang.com/mc/game/version_manifest.json", allowCacheRead, true));
        versions.addAll(MinecraftLauncherMeta.getMeta(Reference.LOCAL_FABRIC_MAVEN_URL + "net/minecraft/experimental_versions.json", false, false));
        if (EXTRA_META_URL != null) {
            versions.addAll(MinecraftLauncherMeta.getMeta(EXTRA_META_URL, false, false));
        }
        versions.sort(Comparator.comparingInt(v -> HIGH_PRIORITY_TYPES.contains(v.type()) ? 0 : 1).thenComparing(Comparator.comparing(Version::releaseTime).reversed()));
        return new MinecraftLauncherMeta(versions);
    }

    public List<Version> getVersions() {
        return this.versions;
    }

    public Version getVersion(String id) {
        Integer idx = this.index.get(id);
        return idx != null ? this.versions.get(idx) : null;
    }

    public int getIndex(String version) {
        return this.index.getOrDefault(version, -1);
    }

    public record Version(String id, String type, String url, byte[] sha1, OffsetDateTime releaseTime, boolean obfuscated) {
        public boolean isStable() {
            return this.type.equals("release");
        }
    }

    static final class MclMetaVersionManifest {
        public List<Version> versions;

        MclMetaVersionManifest() {
        }

        public record Version(String id, String type, String url, String releaseTime, String sha1) {
        }
    }
}

