/*
 * Decompiled with CFR 0.152.
 */
package net.fabricmc.imfwd;

import com.sun.net.httpserver.HttpExchange;
import com.sun.net.httpserver.HttpServer;
import java.io.IOException;
import java.io.OutputStream;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.http.HttpClient;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.nio.charset.StandardCharsets;
import java.time.Duration;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class Main {
    private static final Pattern REQUEST_PATTERN = Pattern.compile("/net/fabricmc/intermediary/([^/]{1,50})/intermediary-\\1\\.([\\.\\w]{1,20})");
    private static final Pattern RESPONSE_PATTERN = Pattern.compile("\"version\": \"([^\"]+)\"");
    private static final String RESPONSE = "<html><head><title>ERR</title></head><body><center><h1>ERR</h1></center></body></html>\n";
    private static final byte[] RESPONSE_302 = "<html><head><title>ERR</title></head><body><center><h1>ERR</h1></center></body></html>\n".replace("ERR", "302 Found").getBytes(StandardCharsets.UTF_8);
    private static final byte[] RESPONSE_404 = "<html><head><title>ERR</title></head><body><center><h1>ERR</h1></center></body></html>\n".replace("ERR", "404 Not Found").getBytes(StandardCharsets.UTF_8);
    private static final byte[] RESPONSE_405 = "<html><head><title>ERR</title></head><body><center><h1>ERR</h1></center></body></html>\n".replace("ERR", "405 Not Allowed").getBytes(StandardCharsets.UTF_8);
    private static final byte[] RESPONSE_500 = "<html><head><title>ERR</title></head><body><center><h1>ERR</h1></center></body></html>\n".replace("ERR", "500 Internal Server Error").getBytes(StandardCharsets.UTF_8);
    private static final HttpClient HTTP_CLIENT = HttpClient.newBuilder().connectTimeout(Duration.ofSeconds(5L)).build();
    private static final Map<String, String> CACHE = Collections.synchronizedMap(new LinkedHashMap<String, String>(500){

        @Override
        protected boolean removeEldestEntry(Map.Entry<String, String> eldest) {
            return this.size() >= 500;
        }
    });
    private static String metaScheme;
    private static String metaHost;
    private static int metaPort;

    public static void main(String[] args) throws IOException {
        if (args.length != 1) {
            throw new IllegalArgumentException("usage: <metaUrl>");
        }
        URI metaUrl = URI.create(args[0]);
        metaScheme = metaUrl.getScheme();
        metaHost = metaUrl.getHost();
        metaPort = metaUrl.getPort();
        HttpServer server = HttpServer.create(new InetSocketAddress(InetAddress.getLoopbackAddress(), 13694), 0);
        server.createContext("/net/fabricmc/intermediary/", Main::handleIntermediary);
        server.start();
        System.out.println("intermediary forwarder running");
    }

    private static void handleIntermediary(HttpExchange exchange) throws IOException {
        try (HttpExchange httpExchange = exchange;){
            int result;
            exchange.getRequestBody().transferTo(OutputStream.nullOutputStream());
            String method = exchange.getRequestMethod();
            if (!method.equals("GET") && !method.equals("HEAD")) {
                exchange.getResponseHeaders().add("Allow", "HEAD, GET");
                result = 405;
            } else {
                String newVersion;
                Matcher matcher = REQUEST_PATTERN.matcher(exchange.getRequestURI().getRawPath());
                if (!matcher.matches() || "".equals(newVersion = Main.getNewIntermediary(matcher.group(1)))) {
                    result = 404;
                } else if (newVersion == null) {
                    result = 500;
                } else {
                    String newLocation = String.format("/net/fabricmc/intermediary/%s/intermediary-%<s.%s", newVersion, matcher.group(2));
                    exchange.getResponseHeaders().add("Location", newLocation);
                    result = 302;
                }
            }
            byte[] response = switch (result) {
                case 302 -> RESPONSE_302;
                case 404 -> RESPONSE_404;
                case 405 -> RESPONSE_405;
                case 500 -> RESPONSE_500;
                default -> throw new IllegalStateException();
            };
            if (method.equals("HEAD")) {
                exchange.getResponseHeaders().set("Content-Length", Integer.toString(response.length));
                exchange.sendResponseHeaders(result, -1L);
            } else {
                exchange.sendResponseHeaders(result, response.length);
                exchange.getResponseBody().write(response);
            }
        }
    }

    private static String getNewIntermediary(String version) {
        String ret = CACHE.get(version);
        if (ret != null) {
            return ret;
        }
        try {
            URI uri = new URI(metaScheme, null, metaHost, metaPort, "/v2/versions/intermediary/" + version, null, null);
            HttpRequest request = HttpRequest.newBuilder(uri).timeout(Duration.ofSeconds(5L)).build();
            HttpResponse<String> response = HTTP_CLIENT.send(request, HttpResponse.BodyHandlers.ofString());
            if (response.statusCode() != 200) {
                return null;
            }
            if (response.body().startsWith("[]")) {
                ret = "";
            } else {
                Matcher matcher = RESPONSE_PATTERN.matcher(response.body());
                if (!matcher.find()) {
                    return null;
                }
                ret = matcher.group(1);
                if (ret.equals(version)) {
                    ret = "";
                }
            }
            CACHE.put(version, ret);
            return ret;
        }
        catch (IOException | InterruptedException | URISyntaxException e) {
            System.out.println("meta request failed: " + String.valueOf(e));
            return null;
        }
    }
}

