/*
 * Decompiled with CFR 0.152.
 */
package org.cadixdev.mercury.mixin.annotation;

import java.util.Arrays;
import java.util.Locale;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.cadixdev.mercury.mixin.annotation.AccessorType;

public final class AccessorName {
    private static final Pattern PATTERN = Pattern.compile("^(" + Arrays.stream(AccessorType.values()).map(AccessorType::getPrefixes).flatMap(Arrays::stream).collect(Collectors.joining("|")) + ")(([A-Z])(.*?))(_\\$md.*)?$");
    private final String methodName;
    private final String prefix;
    private final String name;

    public static AccessorName of(String methodName) {
        return AccessorName.of(methodName, true);
    }

    public static AccessorName of(String methodName, boolean toMemberCase) {
        Matcher nameMatcher = PATTERN.matcher(methodName);
        if (nameMatcher.matches()) {
            String prefix = nameMatcher.group(1);
            String namePart = nameMatcher.group(2);
            String firstChar = nameMatcher.group(3);
            String remainder = nameMatcher.group(4);
            boolean nameIsUpperCase = AccessorName.isUpperCase(Locale.ROOT, namePart);
            String name = String.format("%s%s", AccessorName.toLowerCaseIf(Locale.ROOT, firstChar, toMemberCase && !nameIsUpperCase), remainder);
            return new AccessorName(methodName, prefix, name);
        }
        return null;
    }

    private AccessorName(String methodName, String prefix, String name) {
        this.methodName = methodName;
        this.prefix = prefix;
        this.name = name;
    }

    public String getMethodName() {
        return this.methodName;
    }

    public String getPrefix() {
        return this.prefix;
    }

    public String getName() {
        return this.name;
    }

    public String prefix(String name) {
        String firstChar = name.substring(0, 1);
        String remainder = name.substring(1);
        return this.prefix + AccessorName.toUpperCaseIf(Locale.ROOT, firstChar) + remainder;
    }

    private static boolean isUpperCase(Locale locale, String string) {
        return string.toUpperCase(locale).equals(string);
    }

    private static String toLowerCaseIf(Locale locale, String string, boolean condition) {
        return condition ? string.toLowerCase(locale) : string;
    }

    private static String toUpperCaseIf(Locale locale, String string) {
        return string.toUpperCase(locale);
    }
}

