/*
 * Decompiled with CFR 0.152.
 */
package org.cadixdev.mercury.mixin.annotation;

import java.util.Objects;
import org.cadixdev.mercury.shadow.org.eclipse.jdt.core.dom.IAnnotationBinding;
import org.cadixdev.mercury.shadow.org.eclipse.jdt.core.dom.IMemberValuePairBinding;
import org.cadixdev.mercury.shadow.org.eclipse.jdt.core.dom.ITypeBinding;

public class DescData {
    private final ITypeBinding ownerBinding;
    private final String name;
    private final ITypeBinding returnBinding;
    private final ITypeBinding[] argBindings;

    public static DescData fetch(ITypeBinding binding) {
        for (IAnnotationBinding annotation : binding.getAnnotations()) {
            if (!Objects.equals("org.spongepowered.asm.mixin.injection.Desc", annotation.getAnnotationType().getBinaryName())) continue;
            return DescData.from(annotation);
        }
        return null;
    }

    public static DescData from(IAnnotationBinding binding) {
        ITypeBinding ownerBinding = null;
        String name = null;
        ITypeBinding returnBinding = null;
        ITypeBinding[] argBindings = new ITypeBinding[]{};
        for (IMemberValuePairBinding pair : binding.getDeclaredMemberValuePairs()) {
            if ("owner".equals(pair.getName())) {
                ownerBinding = (ITypeBinding)pair.getValue();
            }
            if ("value".equals(pair.getName())) {
                name = (String)pair.getValue();
            }
            if ("ret".equals(pair.getName())) {
                returnBinding = (ITypeBinding)pair.getValue();
            }
            if (!"args".equals(pair.getName())) continue;
            Object[] targetsTemp = (Object[])pair.getValue();
            argBindings = new ITypeBinding[targetsTemp.length];
            for (int i = 0; i < targetsTemp.length; ++i) {
                argBindings[i] = (ITypeBinding)targetsTemp[i];
            }
        }
        return new DescData(ownerBinding, name, returnBinding, argBindings);
    }

    public DescData(ITypeBinding ownerBinding, String name, ITypeBinding returnBinding, ITypeBinding[] argBindings) {
        this.ownerBinding = ownerBinding;
        this.name = name;
        this.returnBinding = returnBinding;
        this.argBindings = argBindings;
    }

    public ITypeBinding getOwnerBinding() {
        return this.ownerBinding;
    }

    public String getName() {
        return this.name;
    }

    public ITypeBinding getReturnBinding() {
        return this.returnBinding;
    }

    public ITypeBinding[] getArgBindings() {
        return this.argBindings;
    }
}

