/*
 * Decompiled with CFR 0.152.
 */
package org.cadixdev.mercury.extra;

import java.util.Objects;
import org.cadixdev.at.AccessChange;
import org.cadixdev.at.AccessTransform;
import org.cadixdev.at.AccessTransformSet;
import org.cadixdev.at.ModifierChange;
import org.cadixdev.bombe.analysis.InheritanceProvider;
import org.cadixdev.bombe.type.signature.MethodSignature;
import org.cadixdev.lorenz.MappingSet;
import org.cadixdev.lorenz.model.ClassMapping;
import org.cadixdev.mercury.SourceContext;
import org.cadixdev.mercury.SourceProcessor;
import org.cadixdev.mercury.analysis.MercuryInheritanceProvider;
import org.cadixdev.mercury.util.BombeBindings;
import org.cadixdev.mercury.util.GracefulCheck;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.ASTVisitor;
import org.eclipse.jdt.core.dom.AbstractTypeDeclaration;
import org.eclipse.jdt.core.dom.AnonymousClassDeclaration;
import org.eclipse.jdt.core.dom.IBinding;
import org.eclipse.jdt.core.dom.IMethodBinding;
import org.eclipse.jdt.core.dom.ITypeBinding;
import org.eclipse.jdt.core.dom.IVariableBinding;
import org.eclipse.jdt.core.dom.Modifier;
import org.eclipse.jdt.core.dom.SimpleName;

public final class AccessAnalyzerProcessor
implements SourceProcessor {
    private final AccessTransformSet ats;
    private final MappingSet mappings;

    public static AccessAnalyzerProcessor create(AccessTransformSet ats, MappingSet mappings) {
        return new AccessAnalyzerProcessor(ats, mappings);
    }

    private AccessAnalyzerProcessor(AccessTransformSet ats, MappingSet mappings) {
        this.ats = Objects.requireNonNull(ats, "ats");
        this.mappings = Objects.requireNonNull(mappings, "mappings");
    }

    @Override
    public int getFlags() {
        return 1;
    }

    @Override
    public void process(SourceContext context) {
        context.getCompilationUnit().accept((ASTVisitor)new Visitor(context, this.ats, this.mappings));
    }

    private static class Visitor
    extends ASTVisitor {
        private static final AccessTransform TRANSFORM = AccessTransform.of((AccessChange)AccessChange.PUBLIC, (ModifierChange)ModifierChange.NONE);
        private final SourceContext context;
        private final AccessTransformSet ats;
        private final MappingSet mappings;
        private final InheritanceProvider inheritanceProvider;
        private String newPackage;

        private Visitor(SourceContext context, AccessTransformSet ats, MappingSet mappings) {
            this.context = context;
            this.ats = ats;
            this.mappings = mappings;
            this.inheritanceProvider = MercuryInheritanceProvider.get(context.getMercury());
            this.newPackage = this.mappings.getTopLevelClassMapping(context.getQualifiedPrimaryType()).map(primary -> primary.getDeobfuscatedPackage().replace('/', '.')).orElse(context.getPackageName());
        }

        private static ITypeBinding resolveBinding(ASTNode node) {
            if (node instanceof AbstractTypeDeclaration) {
                return ((AbstractTypeDeclaration)node).resolveBinding();
            }
            if (node.getNodeType() == 1) {
                return ((AnonymousClassDeclaration)node).resolveBinding();
            }
            return null;
        }

        private static boolean inheritsBinding(ASTNode node, ITypeBinding declaringClass) {
            while (node != null) {
                ITypeBinding parentBinding = Visitor.resolveBinding(node);
                if (parentBinding != null && parentBinding.isAssignmentCompatible(declaringClass)) {
                    return true;
                }
                node = node.getParent();
            }
            return false;
        }

        private boolean needsTransform(SimpleName node, IBinding binding, ITypeBinding declaringClass) {
            String packageName;
            if (declaringClass == null || GracefulCheck.checkGracefully(this.context, declaringClass)) {
                return false;
            }
            int modifiers = binding.getModifiers();
            if (Modifier.isProtected((int)modifiers) ? Visitor.inheritsBinding((ASTNode)node, declaringClass) : !BombeBindings.isPackagePrivate(modifiers)) {
                return false;
            }
            String binaryName = declaringClass.getBinaryName();
            if (binaryName == null) {
                throw new IllegalStateException("Binary name for binding " + declaringClass.getQualifiedName() + " is null. Did you forget to add a library to the classpath?");
            }
            ClassMapping mapping = this.mappings.getClassMapping(binaryName).orElse(null);
            if (mapping != null) {
                mapping.complete(this.inheritanceProvider, (Object)declaringClass);
                packageName = mapping.getDeobfuscatedPackage().replace('/', '.');
            } else {
                packageName = declaringClass.getPackage().getName();
            }
            return !packageName.equals(this.newPackage);
        }

        private void analyze(SimpleName node, ITypeBinding binding) {
            if (binding.isLocal()) {
                return;
            }
            if (this.needsTransform(node, (IBinding)binding, binding)) {
                this.ats.getOrCreateClass(binding.getBinaryName()).merge(TRANSFORM);
            }
        }

        private void analyze(SimpleName node, IMethodBinding binding) {
            ITypeBinding declaringClass = binding.getDeclaringClass();
            if (this.needsTransform(node, (IBinding)binding, declaringClass)) {
                MethodSignature signature = BombeBindings.convertSignature(binding);
                this.ats.getOrCreateClass(declaringClass.getBinaryName()).mergeMethod(signature, TRANSFORM);
            }
        }

        private void analyze(SimpleName node, IVariableBinding binding) {
            if (!binding.isField()) {
                return;
            }
            ITypeBinding declaringClass = binding.getDeclaringClass();
            if (this.needsTransform(node, (IBinding)binding, declaringClass)) {
                this.ats.getOrCreateClass(declaringClass.getBinaryName()).mergeField(binding.getName(), TRANSFORM);
            }
        }

        public boolean visit(SimpleName node) {
            IBinding binding = node.resolveBinding();
            if (binding == null) {
                return true;
            }
            switch (binding.getKind()) {
                case 2: {
                    this.analyze(node, ((ITypeBinding)binding).getErasure());
                    break;
                }
                case 4: {
                    this.analyze(node, ((IMethodBinding)binding).getMethodDeclaration());
                    break;
                }
                case 3: {
                    this.analyze(node, ((IVariableBinding)binding).getVariableDeclaration());
                }
            }
            return true;
        }
    }
}

