/*
 * Decompiled with CFR 0.152.
 */
package org.cadixdev.mercury.jdt.internal.rewrite.imports;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.cadixdev.mercury.jdt.internal.rewrite.imports.ConflictingSimpleNameFinder;
import org.cadixdev.mercury.jdt.internal.rewrite.imports.ImportName;
import org.cadixdev.mercury.jdt.internal.rewrite.imports.OnDemandComputer;
import org.cadixdev.mercury.jdt.internal.rewrite.imports.OnDemandReduction;
import org.cadixdev.mercury.jdt.internal.rewrite.imports.StaticConflictingSimpleNameFinder;
import org.cadixdev.mercury.jdt.internal.rewrite.imports.TypeConflictingSimpleNameFinder;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jdt.core.JavaModelException;

public class ConflictIdentifier {
    private final OnDemandComputer onDemandComputer;
    private final TypeConflictingSimpleNameFinder typeConflictFinder;
    private final StaticConflictingSimpleNameFinder staticConflictFinder;
    private final Set<String> implicitImportContainers;

    ConflictIdentifier(OnDemandComputer onDemandComputer, TypeConflictingSimpleNameFinder typeConflictFinder, StaticConflictingSimpleNameFinder staticConflictFinder, Set<String> implicitImportContainers) {
        this.onDemandComputer = onDemandComputer;
        this.typeConflictFinder = typeConflictFinder;
        this.staticConflictFinder = staticConflictFinder;
        this.implicitImportContainers = implicitImportContainers;
    }

    Conflicts identifyConflicts(Set<ImportName> imports, Set<ImportName> addedImports, Set<String> typeExplicitSimpleNames, Set<String> staticExplicitSimpleNames, IProgressMonitor progressMonitor) throws JavaModelException {
        Collection<OnDemandReduction> onDemandCandidates = this.onDemandComputer.identifyPossibleReductions(imports, addedImports, typeExplicitSimpleNames, staticExplicitSimpleNames);
        HashSet<String> typeOnDemandContainers = new HashSet<String>(this.extractContainerNames(onDemandCandidates, false));
        HashSet<String> staticOnDemandContainers = new HashSet<String>(this.extractContainerNames(onDemandCandidates, true));
        if (!typeOnDemandContainers.isEmpty()) {
            typeOnDemandContainers.addAll(this.extractOnDemandContainerNames(imports, false));
            typeOnDemandContainers.addAll(this.implicitImportContainers);
            typeOnDemandContainers.addAll(staticOnDemandContainers);
        }
        if (!staticOnDemandContainers.isEmpty()) {
            staticOnDemandContainers.addAll(this.extractOnDemandContainerNames(imports, true));
        }
        Set<String> typeConflicts = this.findConflictingSimpleNames(this.typeConflictFinder, imports, false, typeOnDemandContainers, progressMonitor);
        Set<String> staticConflicts = this.findConflictingSimpleNames(this.staticConflictFinder, imports, true, staticOnDemandContainers, progressMonitor);
        return new Conflicts(typeConflicts, staticConflicts);
    }

    private Collection<String> extractContainerNames(Collection<OnDemandReduction> onDemandCandidates, boolean isStatic) {
        ArrayList<String> containerNames = new ArrayList<String>(onDemandCandidates.size());
        for (OnDemandReduction onDemandCandidate : onDemandCandidates) {
            ImportName containerOnDemand = onDemandCandidate.containerOnDemand;
            if (containerOnDemand.isStatic != isStatic) continue;
            containerNames.add(containerOnDemand.containerName);
        }
        return containerNames;
    }

    private Collection<String> extractOnDemandContainerNames(Collection<ImportName> imports, boolean isStatic) {
        ArrayList<String> onDemandContainerNames = new ArrayList<String>(imports.size());
        for (ImportName importName : imports) {
            if (!importName.isOnDemand() || importName.isStatic != isStatic) continue;
            onDemandContainerNames.add(importName.containerName);
        }
        return onDemandContainerNames;
    }

    private Set<String> findConflictingSimpleNames(ConflictingSimpleNameFinder conflictFinder, Set<ImportName> imports, boolean isStatic, Set<String> onDemandImportedContainers, IProgressMonitor monitor) throws JavaModelException {
        if (onDemandImportedContainers.isEmpty() || imports.isEmpty()) {
            return Collections.emptySet();
        }
        HashSet<String> simpleNames = new HashSet<String>();
        for (ImportName currentImport : imports) {
            if (currentImport.isStatic != isStatic) continue;
            simpleNames.add(currentImport.simpleName);
        }
        return conflictFinder.findConflictingSimpleNames(simpleNames, onDemandImportedContainers, monitor);
    }

    static final class Conflicts {
        final Set<String> typeConflicts;
        final Set<String> staticConflicts;

        Conflicts(Set<String> typeConflicts, Set<String> staticConflicts) {
            this.typeConflicts = Collections.unmodifiableSet(new HashSet<String>(typeConflicts));
            this.staticConflicts = Collections.unmodifiableSet(new HashSet<String>(staticConflicts));
        }

        public String toString() {
            return String.format("Conflicts(type: %s; static: %s)", this.typeConflicts, this.staticConflicts);
        }
    }
}

