/*
 * Decompiled with CFR 0.152.
 */
package org.cadixdev.mercury.remapper;

import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Deque;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.cadixdev.lorenz.MappingSet;
import org.cadixdev.lorenz.model.ClassMapping;
import org.cadixdev.lorenz.model.InnerClassMapping;
import org.cadixdev.lorenz.model.Mapping;
import org.cadixdev.lorenz.model.TopLevelClassMapping;
import org.cadixdev.mercury.RewriteContext;
import org.cadixdev.mercury.jdt.rewrite.imports.ImportRewrite;
import org.cadixdev.mercury.remapper.SimpleRemapperVisitor;
import org.cadixdev.mercury.util.BombeBindings;
import org.cadixdev.mercury.util.GracefulCheck;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.ASTVisitor;
import org.eclipse.jdt.core.dom.AbstractTypeDeclaration;
import org.eclipse.jdt.core.dom.AnnotatableType;
import org.eclipse.jdt.core.dom.AnnotationTypeDeclaration;
import org.eclipse.jdt.core.dom.AnonymousClassDeclaration;
import org.eclipse.jdt.core.dom.EnumDeclaration;
import org.eclipse.jdt.core.dom.IBinding;
import org.eclipse.jdt.core.dom.ITypeBinding;
import org.eclipse.jdt.core.dom.ImportDeclaration;
import org.eclipse.jdt.core.dom.Modifier;
import org.eclipse.jdt.core.dom.Name;
import org.eclipse.jdt.core.dom.NameQualifiedType;
import org.eclipse.jdt.core.dom.PackageDeclaration;
import org.eclipse.jdt.core.dom.QualifiedName;
import org.eclipse.jdt.core.dom.QualifiedType;
import org.eclipse.jdt.core.dom.SimpleName;
import org.eclipse.jdt.core.dom.SimpleType;
import org.eclipse.jdt.core.dom.StructuralPropertyDescriptor;
import org.eclipse.jdt.core.dom.TypeDeclaration;
import org.eclipse.jdt.core.dom.rewrite.ASTRewrite;
import org.eclipse.jdt.core.dom.rewrite.ListRewrite;

class RemapperVisitor
extends SimpleRemapperVisitor {
    private final ImportRewrite importRewrite;
    private final Deque<ImportContext> importStack = new ArrayDeque<ImportContext>();
    private final String simpleDeobfuscatedName;

    RemapperVisitor(RewriteContext context, MappingSet mappings, boolean javadoc) {
        super(context, mappings, javadoc);
        this.importRewrite = context.createImportRewrite();
        this.importRewrite.setUseContextToFilterImplicitImports(true);
        TopLevelClassMapping primary = mappings.getTopLevelClassMapping(context.getQualifiedPrimaryType()).orElse(null);
        if (primary != null) {
            context.setPackageName(primary.getDeobfuscatedPackage().replace('/', '.'));
            this.importRewrite.setImplicitPackageName(context.getPackageName());
            this.simpleDeobfuscatedName = primary.getSimpleDeobfuscatedName();
            context.setPrimaryType(this.simpleDeobfuscatedName);
            ArrayList<String> implicitTypes = new ArrayList<String>();
            String simpleObfuscatedName = primary.getSimpleObfuscatedName();
            List types = context.getCompilationUnit().types();
            for (AbstractTypeDeclaration type : types) {
                String name = type.getName().getIdentifier();
                if (name.equals(simpleObfuscatedName)) {
                    implicitTypes.add(this.simpleDeobfuscatedName);
                    continue;
                }
                implicitTypes.add(mappings.getTopLevelClassMapping(context.getPackageName() + '.' + name).map(Mapping::getSimpleDeobfuscatedName).orElse(name));
            }
            this.importRewrite.setImplicitTypes(implicitTypes);
        } else {
            this.simpleDeobfuscatedName = null;
        }
    }

    private void remapType(SimpleName node, ITypeBinding binding) {
        if (binding.isTypeVariable() || GracefulCheck.checkGracefully(this.context, binding)) {
            return;
        }
        if (binding.getBinaryName() == null) {
            throw new IllegalStateException("Binary name for binding " + binding.getQualifiedName() + " is null. Did you forget to add a library to the classpath?");
        }
        ClassMapping mapping = this.mappings.computeClassMapping(binding.getBinaryName()).orElse(null);
        if (node.getParent() instanceof AbstractTypeDeclaration || node.getParent() instanceof QualifiedType || node.getParent() instanceof NameQualifiedType || binding.isLocal()) {
            if (mapping != null) {
                this.updateIdentifier(node, mapping.getSimpleDeobfuscatedName());
            }
            return;
        }
        String qualifiedName = (mapping != null ? mapping.getFullDeobfuscatedName().replace('/', '.') : binding.getBinaryName()).replace('$', '.');
        String newName = this.importRewrite.addImport(qualifiedName, (ImportRewrite.ImportRewriteContext)this.importStack.peek());
        if (!node.getIdentifier().equals(newName)) {
            if (newName.indexOf(46) == -1) {
                this.context.createASTRewrite().set((ASTNode)node, (StructuralPropertyDescriptor)SimpleName.IDENTIFIER_PROPERTY, (Object)newName, null);
            } else {
                this.context.createASTRewrite().replace((ASTNode)node, (ASTNode)node.getAST().newName(newName), null);
            }
        }
    }

    private void remapQualifiedType(QualifiedName node, ITypeBinding binding) {
        String binaryName = binding.getBinaryName();
        if (binaryName == null) {
            if (this.context.getMercury().isGracefulClasspathChecks() || this.context.getMercury().isGracefulJavadocClasspathChecks() && GracefulCheck.isJavadoc((ASTNode)node)) {
                return;
            }
            throw new IllegalStateException("No binary name for " + binding.getQualifiedName());
        }
        TopLevelClassMapping mapping = this.mappings.getTopLevelClassMapping(binaryName).orElse(null);
        if (mapping == null) {
            return;
        }
        String newName = mapping.getDeobfuscatedName().replace('/', '.');
        if (binaryName.equals(newName)) {
            return;
        }
        this.context.createASTRewrite().replace((ASTNode)node, (ASTNode)node.getAST().newName(newName), null);
    }

    private void remapInnerType(QualifiedName qualifiedName, ITypeBinding outerClass) {
        String binaryName = outerClass.getBinaryName();
        if (binaryName == null) {
            if (this.context.getMercury().isGracefulClasspathChecks()) {
                return;
            }
            throw new IllegalStateException("No binary name for " + outerClass.getQualifiedName());
        }
        ClassMapping outerClassMapping = this.mappings.computeClassMapping(binaryName).orElse(null);
        if (outerClassMapping == null) {
            return;
        }
        SimpleName node = qualifiedName.getName();
        InnerClassMapping mapping = outerClassMapping.getInnerClassMapping(node.getIdentifier()).orElse(null);
        if (mapping == null) {
            return;
        }
        this.updateIdentifier(node, mapping.getDeobfuscatedName());
    }

    @Override
    protected void visit(SimpleName node, IBinding binding) {
        switch (binding.getKind()) {
            case 2: {
                this.remapType(node, (ITypeBinding)binding);
                break;
            }
            case 3: 
            case 4: {
                super.visit(node, binding);
                break;
            }
            default: {
                throw new IllegalStateException("Unhandled binding: " + binding.getClass().getSimpleName() + " (" + binding.getKind() + ')');
            }
        }
    }

    public boolean visit(QualifiedName node) {
        IBinding binding = node.resolveBinding();
        if (binding == null) {
            if (this.context.getMercury().isGracefulClasspathChecks()) {
                return false;
            }
            throw new IllegalStateException("No binding for qualified name node " + node.getFullyQualifiedName());
        }
        if (binding.getKind() != 2) {
            return true;
        }
        Name qualifier = node.getQualifier();
        IBinding qualifierBinding = qualifier.resolveBinding();
        switch (qualifierBinding.getKind()) {
            case 1: {
                this.remapQualifiedType(node, (ITypeBinding)binding);
                break;
            }
            case 2: {
                this.remapInnerType(node, (ITypeBinding)qualifierBinding);
                qualifier.accept((ASTVisitor)this);
                break;
            }
            default: {
                throw new IllegalStateException("Unexpected qualifier binding: " + binding.getClass().getSimpleName() + " (" + binding.getKind() + ')');
            }
        }
        return false;
    }

    public boolean visit(NameQualifiedType node) {
        IBinding qualBinding = node.getQualifier().resolveBinding();
        if (qualBinding != null && qualBinding.getKind() == 2) {
            return true;
        }
        ITypeBinding binding = node.getName().resolveTypeBinding();
        if (binding == null) {
            if (this.context.getMercury().isGracefulClasspathChecks()) {
                return false;
            }
            throw new IllegalStateException("No binding for qualified name node " + node.getName());
        }
        ClassMapping classMapping = this.mappings.computeClassMapping(binding.getBinaryName()).orElse(null);
        if (classMapping == null) {
            return false;
        }
        String deobfPackage = classMapping.getDeobfuscatedPackage();
        ASTRewrite rewrite = this.context.createASTRewrite();
        if (deobfPackage == null || deobfPackage.isEmpty()) {
            SimpleName nameNode;
            if (node.isAnnotatable() && !node.annotations().isEmpty()) {
                SimpleType type = node.getName().getAST().newSimpleType((Name)rewrite.createCopyTarget((ASTNode)node.getName()));
                this.transferAnnotations((AnnotatableType)node, (AnnotatableType)type);
                nameNode = type;
            } else {
                nameNode = node.getName();
            }
            rewrite.replace((ASTNode)node, (ASTNode)nameNode, null);
        } else {
            rewrite.set((ASTNode)node, (StructuralPropertyDescriptor)NameQualifiedType.QUALIFIER_PROPERTY, (Object)node.getAST().newName(deobfPackage.replace('/', '.')), null);
        }
        node.getName().accept((ASTVisitor)this);
        return false;
    }

    public boolean visit(PackageDeclaration node) {
        String currentPackage = node.getName().getFullyQualifiedName();
        if (this.context.getPackageName().isEmpty()) {
            this.context.createASTRewrite().remove((ASTNode)node, null);
        } else if (!currentPackage.equals(this.context.getPackageName())) {
            this.context.createASTRewrite().replace((ASTNode)node.getName(), (ASTNode)node.getAST().newName(this.context.getPackageName()), null);
        }
        return false;
    }

    public boolean visit(ImportDeclaration node) {
        if (node.isStatic()) {
            return true;
        }
        IBinding binding = node.resolveBinding();
        if (binding != null) {
            switch (binding.getKind()) {
                case 2: {
                    ITypeBinding typeBinding = (ITypeBinding)binding;
                    String name = typeBinding.getBinaryName();
                    if (name == null) {
                        if (this.context.getMercury().isGracefulClasspathChecks()) {
                            return false;
                        }
                        throw new IllegalStateException("No binary name for " + typeBinding.getQualifiedName() + ". Did you add the library to the classpath?");
                    }
                    ClassMapping mapping = this.mappings.computeClassMapping(name).orElse(null);
                    if (mapping != null && !name.equals(mapping.getFullDeobfuscatedName().replace('/', '.'))) {
                        this.importRewrite.removeImport(typeBinding.getQualifiedName());
                        break;
                    }
                    if (this.simpleDeobfuscatedName == null || !this.simpleDeobfuscatedName.equals(typeBinding.getName())) break;
                    this.importRewrite.removeImport(typeBinding.getQualifiedName());
                }
            }
        }
        return false;
    }

    private void pushImportContext(ITypeBinding binding) {
        ImportContext context = new ImportContext(this.importRewrite.getDefaultImportRewriteContext(), this.importStack.peek());
        this.collectImportContext(context, binding);
        this.importStack.push(context);
    }

    private void collectImportContext(ImportContext context, ITypeBinding binding) {
        if (binding == null) {
            return;
        }
        for (ITypeBinding inner : binding.getDeclaredTypes()) {
            String current;
            String qualifiedName;
            String simpleName;
            int modifiers;
            if (GracefulCheck.checkGracefully(this.context, inner) || Modifier.isPrivate((int)(modifiers = inner.getModifiers())) && this.context.getCompilationUnit().findDeclaringNode((IBinding)inner) == null) continue;
            ClassMapping mapping = this.mappings.getClassMapping(inner.getBinaryName()).orElse(null);
            if (BombeBindings.isPackagePrivate(modifiers)) {
                String packageName;
                String string = packageName = mapping != null ? mapping.getDeobfuscatedPackage() : inner.getPackage().getName();
                if (packageName.equals(this.context.getPackageName())) continue;
            }
            if (mapping != null) {
                simpleName = mapping.getSimpleDeobfuscatedName();
                qualifiedName = mapping.getFullDeobfuscatedName().replace('/', '.').replace('$', '.');
            } else {
                simpleName = inner.getName();
                qualifiedName = inner.getBinaryName().replace('$', '.');
            }
            if (context.conflicts.contains(simpleName) || (current = context.implicit.putIfAbsent(simpleName, qualifiedName)) == null || current.equals(qualifiedName)) continue;
            context.implicit.remove(simpleName);
            context.conflicts.add(simpleName);
        }
        this.collectImportContext(context, binding.getSuperclass());
        for (ITypeBinding parent : binding.getInterfaces()) {
            this.collectImportContext(context, parent);
        }
    }

    public boolean visit(AnnotationTypeDeclaration node) {
        this.pushImportContext(node.resolveBinding());
        return true;
    }

    public boolean visit(AnonymousClassDeclaration node) {
        this.pushImportContext(node.resolveBinding());
        return true;
    }

    public boolean visit(EnumDeclaration node) {
        this.pushImportContext(node.resolveBinding());
        return true;
    }

    public boolean visit(TypeDeclaration node) {
        this.pushImportContext(node.resolveBinding());
        return true;
    }

    public void endVisit(AnnotationTypeDeclaration node) {
        this.importStack.pop();
    }

    public void endVisit(AnonymousClassDeclaration node) {
        this.importStack.pop();
    }

    public void endVisit(EnumDeclaration node) {
        this.importStack.pop();
    }

    public void endVisit(TypeDeclaration node) {
        this.importStack.pop();
    }

    private void transferAnnotations(AnnotatableType oldNode, AnnotatableType newNode) {
        if (newNode.getAST().apiLevel() < 8) {
            return;
        }
        if (oldNode.annotations().isEmpty()) {
            return;
        }
        ListRewrite rewrite = this.context.createASTRewrite().getListRewrite((ASTNode)newNode, newNode.getAnnotationsProperty());
        for (Object annotation : oldNode.annotations()) {
            ASTNode annotationNode = (ASTNode)annotation;
            annotationNode.accept((ASTVisitor)this);
            rewrite.insertLast(annotationNode, null);
        }
    }

    private static class ImportContext
    extends ImportRewrite.ImportRewriteContext {
        private final ImportRewrite.ImportRewriteContext defaultContext;
        final Map<String, String> implicit;
        final Set<String> conflicts;

        ImportContext(ImportRewrite.ImportRewriteContext defaultContext, ImportContext parent) {
            this.defaultContext = defaultContext;
            if (parent != null) {
                this.implicit = new HashMap<String, String>(parent.implicit);
                this.conflicts = new HashSet<String>(parent.conflicts);
            } else {
                this.implicit = new HashMap<String, String>();
                this.conflicts = new HashSet<String>();
            }
        }

        @Override
        public int findInContext(String qualifier, String name, int kind) {
            int result = this.defaultContext.findInContext(qualifier, name, kind);
            if (result != 2) {
                return result;
            }
            if (kind == 1) {
                String current = this.implicit.get(name);
                if (current != null) {
                    return current.equals(qualifier + '.' + name) ? 1 : 3;
                }
                if (this.conflicts.contains(name)) {
                    return 3;
                }
            }
            return 2;
        }
    }
}

