/*
 * Decompiled with CFR 0.152.
 */
package org.cadixdev.mercury.remapper;

import java.util.Objects;
import java.util.Optional;
import java.util.function.BiFunction;
import org.cadixdev.bombe.analysis.InheritanceProvider;
import org.cadixdev.bombe.type.signature.FieldSignature;
import org.cadixdev.bombe.type.signature.MethodSignature;
import org.cadixdev.lorenz.MappingSet;
import org.cadixdev.lorenz.model.ClassMapping;
import org.cadixdev.lorenz.model.FieldMapping;
import org.cadixdev.lorenz.model.InnerClassMapping;
import org.cadixdev.lorenz.model.MemberMapping;
import org.cadixdev.lorenz.model.MethodMapping;
import org.cadixdev.mercury.RewriteContext;
import org.cadixdev.mercury.analysis.MercuryInheritanceProvider;
import org.cadixdev.mercury.util.BombeBindings;
import org.cadixdev.mercury.util.GracefulCheck;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.ASTVisitor;
import org.eclipse.jdt.core.dom.IBinding;
import org.eclipse.jdt.core.dom.IMethodBinding;
import org.eclipse.jdt.core.dom.ITypeBinding;
import org.eclipse.jdt.core.dom.IVariableBinding;
import org.eclipse.jdt.core.dom.SimpleName;
import org.eclipse.jdt.core.dom.StructuralPropertyDescriptor;

class SimpleRemapperVisitor
extends ASTVisitor {
    final RewriteContext context;
    final MappingSet mappings;
    private final InheritanceProvider inheritanceProvider;

    SimpleRemapperVisitor(RewriteContext context, MappingSet mappings, boolean javadoc) {
        super(javadoc);
        this.context = context;
        this.mappings = mappings;
        this.inheritanceProvider = MercuryInheritanceProvider.get(context.getMercury());
    }

    final void updateIdentifier(SimpleName node, String newName) {
        if (!node.getIdentifier().equals(newName)) {
            this.context.createASTRewrite().set((ASTNode)node, (StructuralPropertyDescriptor)SimpleName.IDENTIFIER_PROPERTY, (Object)newName, null);
        }
    }

    private void remapMethod(SimpleName node, IMethodBinding binding) {
        ITypeBinding declaringClass = binding.getDeclaringClass();
        if (GracefulCheck.checkGracefully(this.context, declaringClass)) {
            return;
        }
        ClassMapping classMapping = this.mappings.getOrCreateClassMapping(declaringClass.getBinaryName());
        if (binding.isConstructor()) {
            this.updateIdentifier(node, classMapping.getSimpleDeobfuscatedName());
        } else {
            MethodSignature bindingSignature = BombeBindings.convertSignature(binding);
            MethodMapping mapping = (MethodMapping)this.findMemberMapping(bindingSignature, classMapping, ClassMapping::getMethodMapping);
            if (mapping == null) {
                classMapping.complete(this.inheritanceProvider, (Object)declaringClass);
                mapping = classMapping.getMethodMapping(bindingSignature).orElse(null);
            }
            if (mapping == null) {
                return;
            }
            this.updateIdentifier(node, mapping.getDeobfuscatedName());
        }
    }

    private void remapField(SimpleName node, IVariableBinding binding) {
        if (!binding.isField()) {
            return;
        }
        ITypeBinding declaringClass = binding.getDeclaringClass();
        if (declaringClass == null) {
            return;
        }
        ClassMapping classMapping = this.mappings.getClassMapping(declaringClass.getBinaryName()).orElse(null);
        if (classMapping == null) {
            return;
        }
        FieldSignature bindingSignature = BombeBindings.convertSignature(binding);
        FieldMapping mapping = (FieldMapping)this.findMemberMapping(bindingSignature, classMapping, ClassMapping::computeFieldMapping);
        if (mapping == null) {
            return;
        }
        this.updateIdentifier(node, mapping.getDeobfuscatedName());
    }

    private <T extends MemberMapping<?, ?>, M> T findMemberMapping(M matcher, ClassMapping<?, ?> classMapping, BiFunction<ClassMapping<?, ?>, M, Optional<? extends T>> getMapping) {
        MemberMapping mapping = getMapping.apply(classMapping, matcher).orElse(null);
        if (mapping != null) {
            return (T)mapping;
        }
        return this.findMemberMappingAnonClass(matcher, classMapping, getMapping);
    }

    private <T extends MemberMapping<?, ?>, M> T findMemberMappingAnonClass(M matcher, ClassMapping<?, ?> classMapping, BiFunction<ClassMapping<?, ?>, M, Optional<? extends T>> getMapping) {
        MemberMapping mapping;
        if (Objects.equals(classMapping.getObfuscatedName(), classMapping.getDeobfuscatedName())) {
            return null;
        }
        if (!(classMapping instanceof InnerClassMapping)) {
            return null;
        }
        if (!classMapping.getObfuscatedName().chars().allMatch(Character::isDigit)) {
            return null;
        }
        ClassMapping parentMapping = (ClassMapping)((InnerClassMapping)classMapping).getParent();
        if (parentMapping == null) {
            return null;
        }
        ClassMapping otherClassMapping = parentMapping.getInnerClassMapping(classMapping.getDeobfuscatedName()).orElse(null);
        if (otherClassMapping != null && (mapping = (MemberMapping)getMapping.apply(otherClassMapping, matcher).orElse(null)) != null) {
            return (T)mapping;
        }
        for (InnerClassMapping innerClassMapping : parentMapping.getInnerClassMappings()) {
            if (!Objects.equals(classMapping.getObfuscatedName(), innerClassMapping.getDeobfuscatedName())) continue;
            otherClassMapping = innerClassMapping;
            break;
        }
        if (otherClassMapping == null) {
            return null;
        }
        return (T)((MemberMapping)getMapping.apply(otherClassMapping, matcher).orElse(null));
    }

    protected void visit(SimpleName node, IBinding binding) {
        switch (binding.getKind()) {
            case 4: {
                this.remapMethod(node, ((IMethodBinding)binding).getMethodDeclaration());
                break;
            }
            case 3: {
                this.remapField(node, ((IVariableBinding)binding).getVariableDeclaration());
            }
        }
    }

    public final boolean visit(SimpleName node) {
        IBinding binding = node.resolveBinding();
        if (binding != null) {
            this.visit(node, binding);
        }
        return false;
    }
}

