/*
 * Decompiled with CFR 0.152.
 */
package team.reborn.energy.impl;

import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import net.minecraft.core.Registry;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.resources.Identifier;
import net.minecraft.world.item.Item;
import org.jetbrains.annotations.ApiStatus;
import team.reborn.energy.api.EnergyStorage;
import team.reborn.energy.api.base.SimpleEnergyItem;

@ApiStatus.Internal
public class EnergyImpl {
    public static final DataComponentType<Long> ENERGY_COMPONENT = DataComponentType.builder().persistent(EnergyImpl.nonNegativeLong()).networkSynchronized(ByteBufCodecs.VAR_LONG).build();

    public static void init() {
        Registry.register((Registry)BuiltInRegistries.DATA_COMPONENT_TYPE, (Identifier)Identifier.fromNamespaceAndPath((String)"team_reborn_energy", (String)"energy"), ENERGY_COMPONENT);
        EnergyStorage.ITEM.registerFallback((stack, ctx) -> {
            Item patt0$temp = stack.getItem();
            if (patt0$temp instanceof SimpleEnergyItem) {
                SimpleEnergyItem energyItem = (SimpleEnergyItem)patt0$temp;
                return SimpleEnergyItem.createStorage(ctx, energyItem.getEnergyCapacity(stack), energyItem.getEnergyMaxInput(stack), energyItem.getEnergyMaxOutput(stack));
            }
            return null;
        });
    }

    private static Codec<Long> nonNegativeLong() {
        return Codec.LONG.validate(value -> {
            if (value >= 0L) {
                return DataResult.success((Object)value);
            }
            return DataResult.error(() -> "Energy value must be non-negative: " + value);
        });
    }
}

